/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.module;

import cn.jants.common.bean.Log;
import cn.jants.core.context.AppConstant;
import cn.jants.core.module.DbManager;
import cn.jants.core.utils.ScanUtil;
import cn.jants.plugin.db.Db;
import cn.jants.plugin.sqlmap.MapperProxy;
import cn.jants.plugin.sqlmap.annotation.Mapper;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class MapperManager {
    private static final ConcurrentMap<String, Object> MAPPERS = new ConcurrentHashMap<String, Object>();

    public static void register(String ... packages) {
        List<Class<?>> mapperCls = ScanUtil.findScanClass(packages, Mapper.class);
        if (mapperCls.size() > 0) {
            Db db = new Db();
            DbManager.add("_default", db);
        }
        for (Class<?> cls : mapperCls) {
            String simpleName = cls.getSimpleName();
            if (AppConstant.DEBUG.booleanValue()) {
                Log.debug(">>> {} :: Generator Success !", simpleName);
            }
            MapperProxy mapperProxy = new MapperProxy(simpleName, cls);
            MAPPERS.put(simpleName, mapperProxy.getProxy());
        }
        if (AppConstant.DEBUG.booleanValue()) {
            Log.debug(">>> \u5171\u8ba1 {} \u4e2aMapper", mapperCls.size());
        }
    }

    public static Object getMapper(Class cls) {
        return MAPPERS.get(cls.getSimpleName());
    }
}

