/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.proxy;

import cn.jants.common.annotation.service.Autowired;
import cn.jants.common.annotation.service.Source;
import cn.jants.common.annotation.service.Value;
import cn.jants.common.bean.Log;
import cn.jants.common.bean.Prop;
import cn.jants.common.enums.DataSourceType;
import cn.jants.core.ext.InitializingBean;
import cn.jants.core.module.DbManager;
import cn.jants.core.module.MapperManager;
import cn.jants.core.module.ServiceManager;
import cn.jants.core.proxy.CglibProxy;
import cn.jants.core.utils.GenerateUtil;
import cn.jants.core.utils.ParamTypeUtil;
import cn.jants.plugin.db.Db;
import cn.jants.plugin.sqlmap.annotation.Mapper;
import cn.jants.restful.bind.utils.ReflectionUtils;
import java.lang.reflect.Field;
import javax.sql.DataSource;

public class FiledBinding {
    public static void initFiledValues(Object object) {
        Field[] fields;
        Class<?> cls = object.getClass();
        for (Field field : fields = cls.getDeclaredFields()) {
            if (field.isAnnotationPresent(Autowired.class)) {
                Class<?> typeClass = field.getType();
                ReflectionUtils.makeAccessible(field);
                if (typeClass.isAnnotationPresent(Mapper.class)) {
                    Object mapper = MapperManager.getMapper(typeClass);
                    try {
                        field.set(object, mapper);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                String key = "";
                try {
                    Object service;
                    Class targetClass = field.getDeclaredAnnotation(Autowired.class).value();
                    if (typeClass.isInterface() && targetClass == Autowired.class) {
                        service = ServiceManager.getService(typeClass);
                        if (service == null) {
                            throw new RuntimeException(cls + " \u4e2d\u542b\u6709@Service\u6ce8\u89e3\u7c7b\u4e2d, \u4e0d\u80fd\u6ce8\u5165\u63a5\u53e3!");
                        }
                    } else {
                        String cName = targetClass == Autowired.class ? typeClass.getName() : targetClass.getName();
                        key = GenerateUtil.createServiceKey(cName);
                        service = ServiceManager.getService(key);
                        if (service == null) {
                            service = Class.forName(cName).newInstance();
                            FiledBinding.initFiledValues(service);
                            Object proxy = CglibProxy.createProxy(service);
                            if (proxy instanceof InitializingBean) {
                                InitializingBean ib = (InitializingBean)service;
                                ib.afterPropertiesSet();
                            }
                            ServiceManager.setService(key, proxy);
                        }
                    }
                    field.set(object, service);
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    throw new RuntimeException(cls + " " + key + " \u5b9e\u4f8b\u5316\u5931\u8d25, \u8bf7\u8ba4\u771f\u68c0\u67e5!");
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (field.isAnnotationPresent(Value.class)) {
                try {
                    Value v = field.getDeclaredAnnotation(Value.class);
                    Object paramValue = Prop.getKeyValue(cls.getName(), v.value());
                    Object objectValue = ParamTypeUtil.parse(String.valueOf(paramValue), field.getType());
                    ReflectionUtils.makeAccessible(field);
                    field.set(object, objectValue);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!field.isAnnotationPresent(Source.class) || field.getType() != Db.class) continue;
            try {
                Db db;
                ReflectionUtils.makeAccessible(field);
                Source source = field.getDeclaredAnnotation(Source.class);
                if ("".equals(source.value()) && source.type() == DataSourceType.NONE) {
                    if (DbManager.containsKey("_default")) {
                        field.set(object, DbManager.get("_default"));
                        continue;
                    }
                    db = new Db();
                    field.set(object, db);
                    DbManager.add("_default", db);
                    continue;
                }
                db = DbManager.get(source.value());
                if (db == null) {
                    if (source.type() == DataSourceType.NONE) {
                        db = DataSourceType.getNativeDb(source.value());
                    } else {
                        DataSource dataSource = DataSourceType.getDataSource(source);
                        if (dataSource == null) {
                            Log.warn("@Source \u6307\u5b9a\u4e86 {} \u6570\u636e\u6e90, \u5374\u6ca1\u6709\u8fdb\u884c\u914d\u7f6e!", new Object[]{source.type()});
                            db = new Db();
                        } else {
                            db = new Db(dataSource);
                        }
                    }
                    DbManager.add(source.value(), db);
                }
                field.set(object, db);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

