/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.startup;

import cn.jants.common.utils.StrUtil;
import cn.jants.core.context.AntsFilter;
import cn.jants.core.startup.CommonProperty;
import cn.jants.core.startup.assembly.FilterAssembly;
import cn.jants.core.startup.assembly.ServletAssembly;
import cn.jants.core.startup.servlet.IndexServlet;
import cn.jants.core.startup.servlet.LogoServlet;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.AprLifecycleListener;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;

public class JTomcat
extends CommonProperty {
    public JTomcat(Class loadClass, int port, String contextPath) {
        super(loadClass, port, contextPath);
    }

    @Override
    public JTomcat start() {
        Tomcat tomcat = new Tomcat();
        tomcat.setPort(this.port);
        tomcat.setBaseDir(".");
        Connector connector = tomcat.getConnector();
        Http11NioProtocol protocol = (Http11NioProtocol)connector.getProtocolHandler();
        protocol.setMaxConnections(this.maxConnections.intValue());
        protocol.setMaxThreads(this.maxThreads.intValue());
        protocol.setConnectionTimeout(this.connectionTimeout.intValue());
        connector.setURIEncoding(this.charset);
        connector.setUseBodyEncodingForURI(true);
        StandardServer server = (StandardServer)tomcat.getServer();
        AprLifecycleListener listener = new AprLifecycleListener();
        server.addLifecycleListener((LifecycleListener)listener);
        tomcat.getHost().setAppBase(".");
        try {
            Context ctx = tomcat.addWebapp(this.contextPath, this.webApp == null ? "." : this.webApp);
            tomcat.addServlet(this.contextPath, "indexServlet", (Servlet)new IndexServlet());
            ctx.addServletMapping("", "indexServlet");
            tomcat.addServlet(this.contextPath, "logoServlet", (Servlet)new LogoServlet());
            ctx.addServletMapping("/ants-logo", "logoServlet");
            ctx.addMimeMapping("woff", "application/x-font-woff");
            ctx.addMimeMapping("woff2", "application/x-font-woff");
            ctx.addMimeMapping("ttf", "application/octet-stream");
            ctx.addMimeMapping("otf", "application/octet-stream");
            ctx.setAllowCasualMultipartParsing(true);
            if (StrUtil.notNull(this.servlets)) {
                for (ServletAssembly servlet : this.servlets) {
                    tomcat.addServlet(this.contextPath, servlet.getServletName(), (Servlet)servlet.getServlet());
                    ctx.addServletMapping(servlet.getUrlPattern(), servlet.getServletName());
                }
            }
            FilterDef fd = new FilterDef();
            fd.setFilterName("AntsFilter");
            fd.setFilter((Filter)new AntsFilter());
            fd.addInitParameter("loadClass", this.loadClass.getName());
            ctx.addFilterDef(fd);
            FilterMap fm = new FilterMap();
            fm.setFilterName("AntsFilter");
            fm.addURLPattern("/*");
            ctx.addFilterMap(fm);
            if (StrUtil.notNull(this.filters)) {
                for (FilterAssembly filter : this.filters) {
                    fd.setFilterName(filter.getFilterName());
                    fd.setFilter(filter.getFilter());
                    ctx.addFilterDef(fd);
                    fm.setFilterName(filter.getFilterName());
                    fm.addURLPattern(filter.getUrlPattern());
                    ctx.addFilterMap(fm);
                }
            }
            tomcat.start();
            tomcat.getServer().await();
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
        catch (LifecycleException e) {
            e.printStackTrace();
        }
        return this;
    }

    public static void run(Class loadClass) {
        new JTomcat(loadClass, 8080, "").start();
    }

    public static void run(Class loadClass, int port) {
        new JTomcat(loadClass, port, "").start();
    }

    public static void run(Class loadClass, String contextPath) {
        new JTomcat(loadClass, 8080, contextPath).start();
    }

    public static void run(Class loadClass, int port, String contextPath) {
        new JTomcat(loadClass, port, contextPath).start();
    }
}

