/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.db;

import cn.jants.common.bean.JsonMap;
import cn.jants.common.bean.Page;
import cn.jants.common.bean.PageConditions;
import cn.jants.common.bean.Prop;
import cn.jants.common.enums.TxLevel;
import cn.jants.common.exception.SQLParamsException;
import cn.jants.common.utils.StrCaseUtil;
import cn.jants.common.utils.StrUtil;
import cn.jants.core.context.AppConstant;
import cn.jants.core.utils.ParamTypeUtil;
import cn.jants.plugin.db.C3p0Plugin;
import cn.jants.plugin.db.DbcpPlugin;
import cn.jants.plugin.db.DruidPlugin;
import cn.jants.plugin.db.HikariCpPlugin;
import cn.jants.plugin.orm.Criteria;
import cn.jants.plugin.orm.Table;
import cn.jants.plugin.orm.enums.OrderBy;
import cn.jants.plugin.sqlmap.SqlParams;
import cn.jants.plugin.sqlmap.SqlStatement;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db<T> {
    private static final Logger logger = LoggerFactory.getLogger(Db.class);
    protected ThreadLocal<Connection> connections = new ThreadLocal();
    protected DataSource dataSource;
    private String name;
    private String url;
    private String driverClassName;
    private String username;
    private String password;
    private Connection conn = null;

    public Db() {
        this.name = "_default";
        this.url = Prop.getStr("ants.db.url");
        this.driverClassName = Prop.getStr("ants.db.driver-class-name");
        this.username = Prop.getStr("ants.db.username");
        this.password = Prop.getStr("ants.db.password");
        String dataSourceTypeStr = Prop.getStr("ants.db.data-source");
        if ("druid".equalsIgnoreCase(dataSourceTypeStr)) {
            Properties properties = Prop.getProperties("ants.db.data-source.druid");
            this.dataSource = new DruidPlugin(this.url, this.driverClassName, this.username, this.password).getDataSource(properties);
        } else if ("c3p0".equalsIgnoreCase(dataSourceTypeStr)) {
            this.dataSource = C3p0Plugin.getDataSource(this.url, this.driverClassName, this.username, this.password);
        } else if ("dbcp".equalsIgnoreCase(dataSourceTypeStr)) {
            Properties properties = Prop.getProperties("ants.db.data-source.dbcp");
            this.dataSource = new DbcpPlugin(this.url, this.driverClassName, this.username, this.password).getDataSource(properties);
        } else if ("hikaricp".equalsIgnoreCase(dataSourceTypeStr)) {
            Properties properties = Prop.getProperties("ants.db.data-source.hikaricp");
            this.dataSource = new HikariCpPlugin(this.url, this.driverClassName, this.username, this.password).getDataSource(properties);
        }
        this.getConnection();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Db(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Connection getConnection() {
        if (this.dataSource == null) {
            try {
                Class.forName(this.driverClassName);
                this.conn = DriverManager.getConnection(this.url, this.username, this.password);
                this.connections.set(this.conn);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                logger.debug("\u539f\u751f\u52a0\u8f7d com.mysql.jdbc.Driver \u5931\u8d25!");
            }
            catch (SQLException e) {
                e.printStackTrace();
                logger.debug("\u539f\u751f\u8fde\u63a5\u6570\u636e\u5e93\u5931\u8d25, \u8bf7\u8ba4\u771f\u68c0\u67e5\u914d\u7f6e!");
            }
        } else {
            try {
                this.conn = this.dataSource.getConnection();
                this.connections.set(this.conn);
            }
            catch (SQLException e) {
                e.printStackTrace();
                logger.debug("\u83b7\u53d6\u6570\u636e\u6e90\u5931\u8d25, \u8bf7\u8ba4\u771f\u68c0\u67e5\u914d\u7f6e!");
            }
        }
        return this.conn;
    }

    public Db(String name, String url, String driverClassName, String username, String password) {
        this.name = name;
        this.url = url;
        this.driverClassName = driverClassName;
        this.username = username;
        this.password = password;
        this.getConnection();
    }

    public void startTx(DataSource dataSource, String currentSource, TxLevel level) {
        if (dataSource == null && this.conn == null) {
            throw new RuntimeException(currentSource + " \u6ca1\u6709\u914d\u7f6e\u6570\u636e\u6e90, \u9519\u8bef!");
        }
        Connection conn = this.connections.get();
        try {
            if (dataSource != null && conn == null) {
                conn = dataSource.getConnection();
            } else if (dataSource == null && conn == null) {
                conn = this.getConnection();
            }
            this.connections.set(conn);
            conn.setAutoCommit(false);
            conn.setTransactionIsolation(level.level());
            logger.debug(currentSource + "start transactional level {} [{}] !", (Object)level, (Object)conn);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void commit() throws SQLException {
        Connection conn = this.connections.get();
        if (conn != null) {
            conn.commit();
            this.close(conn);
            logger.debug("Commit transactional {} !", (Object)conn);
        }
    }

    public void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
                this.connections.remove();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void close(PreparedStatement ps) {
        this.close(null, ps);
    }

    public void close(ResultSet rs, PreparedStatement ps) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void rollback() {
        Connection conn = this.connections.get();
        try {
            if (conn != null) {
                conn.rollback();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        logger.debug("RollBack transactional {} !", (Object)conn);
    }

    public int[] batch(String sql, Object[] ... params) {
        Object rows = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            boolean check = false;
            Connection conn = this.connections.get();
            if (conn == null) {
                conn = this.getConnection();
                check = true;
            }
            if (sql == null) {
                if (conn != null) {
                    conn.close();
                }
                throw new SQLException("Null SQL statement");
            }
            ps = conn.prepareStatement(sql);
            if (params != null && params.length != 0) {
                for (int i = 0; i < params.length; ++i) {
                    this.fillStatement(sql, ps, params[i]);
                    ps.addBatch();
                }
            }
            int[] res = ps.executeBatch();
            if (check) {
                this.close(conn);
            }
            int[] nArray = res;
            this.close(rs, ps);
            return nArray;
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new SQLParamsException(e);
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
        }
    }

    public Long[] batchReturnKey(String sql, Object[] ... params) {
        Long[] keys = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            int i;
            boolean check = false;
            Connection conn = this.connections.get();
            if (conn == null) {
                conn = this.getConnection();
                check = true;
            }
            if (sql == null) {
                if (conn != null) {
                    conn.close();
                }
                throw new SQLException("Null SQL statement");
            }
            ps = conn.prepareStatement(sql, 1);
            if (params != null && params.length != 0) {
                for (i = 0; i < params.length; ++i) {
                    this.fillStatement(sql, ps, params[i]);
                    ps.addBatch();
                }
            }
            ps.executeBatch();
            rs = ps.getGeneratedKeys();
            if (rs.first()) {
                keys = new Long[rs.getRow()];
                i = 0;
                while (rs.next()) {
                    keys[i] = rs.getLong(1);
                    ++i;
                }
            }
            if (check) {
                this.close(conn);
            }
            Long[] longArray = keys;
            this.close(rs, ps);
            return longArray;
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new SQLParamsException(e);
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
        }
    }

    public Long insertReturnKey(String sql, Object ... params) {
        Connection conn;
        boolean check;
        ResultSet rs;
        PreparedStatement ps;
        block9: {
            ps = null;
            rs = null;
            check = false;
            conn = this.connections.get();
            if (conn == null) {
                conn = this.getConnection();
                check = true;
            }
            if (sql == null) {
                if (conn != null) {
                    conn.close();
                }
                throw new SQLException("Null SQL statement");
            }
            ps = conn.prepareStatement(sql, 1);
            this.fillStatement(sql, ps, params);
            ps.executeUpdate();
            rs = ps.getGeneratedKeys();
            if (!rs.first()) break block9;
            Long l = rs.getLong(1);
            this.close(rs, ps);
            return l;
        }
        try {
            if (check) {
                this.close(conn);
            }
            this.close(rs, ps);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new SQLParamsException(e);
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
        }
        return null;
    }

    public void insert(String sql, Object ... params) {
        PreparedStatement ps = null;
        Object rs = null;
        try {
            boolean check = false;
            Connection conn = this.connections.get();
            if (conn == null) {
                conn = this.getConnection();
                check = true;
            }
            if (sql == null) {
                if (conn != null) {
                    conn.close();
                }
                throw new SQLException("Null SQL statement");
            }
            ps = conn.prepareStatement(sql, 1);
            this.fillStatement(sql, ps, params);
            ps.execute();
            if (check) {
                this.close(conn);
            }
            this.close(ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLParamsException(e);
            }
            catch (Throwable throwable) {
                this.close(ps);
                throw throwable;
            }
        }
    }

    public int update(String sql, Object ... params) {
        PreparedStatement ps = null;
        try {
            boolean check = false;
            Connection conn = this.connections.get();
            if (conn == null) {
                conn = this.getConnection();
                check = true;
            }
            if (sql == null) {
                if (conn != null) {
                    conn.close();
                }
                throw new SQLException("Null SQL statement");
            }
            ps = conn.prepareStatement(sql);
            this.fillStatement(sql, ps, params);
            int res = ps.executeUpdate();
            if (check) {
                this.close(conn);
            }
            int n = res;
            this.close(ps);
            return n;
        }
        catch (SQLException e) {
            try {
                throw new SQLParamsException(e);
            }
            catch (Throwable throwable) {
                this.close(ps);
                throw throwable;
            }
        }
    }

    public int update(String sql) {
        return this.update(sql, null);
    }

    public JsonMap query(String sql, Object ... params) {
        JsonMap result = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            boolean check = false;
            Connection conn = this.connections.get();
            if (conn == null) {
                conn = this.getConnection();
                check = true;
            }
            if (sql == null) {
                if (conn != null) {
                    conn.close();
                }
                throw new SQLException("Null SQL statement");
            }
            ps = conn.prepareStatement(sql);
            this.fillStatement(sql, ps, params);
            rs = ps.executeQuery();
            if (rs.first()) {
                result = JsonMap.newJsonMap();
                ResultSetMetaData rsm = rs.getMetaData();
                for (int j = 1; j <= rsm.getColumnCount(); ++j) {
                    String columnName = rsm.getColumnLabel(j);
                    Object val = rs.getObject(columnName);
                    result.set(AppConstant.HUMP ? StrCaseUtil.toCamelCase(columnName) : columnName, val);
                }
            }
            if (check) {
                this.close(conn);
            }
            this.close(rs, ps);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new SQLParamsException(e);
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
        }
        return result;
    }

    public JsonMap query(String sql) {
        return this.query(sql, new Object[0]);
    }

    public Object queryOne(String sql, Object ... params) {
        Object result = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            boolean check = false;
            Connection conn = this.connections.get();
            if (conn == null) {
                conn = this.getConnection();
                check = true;
            }
            if (sql == null) {
                if (conn != null) {
                    conn.close();
                }
                throw new SQLException("Null SQL statement");
            }
            ps = conn.prepareStatement(sql);
            this.fillStatement(sql, ps, params);
            rs = ps.executeQuery();
            if (rs.first()) {
                result = rs.getObject(1);
            }
            if (check) {
                this.close(conn);
            }
            this.close(rs, ps);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new SQLParamsException(e);
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
        }
        return result;
    }

    public List<JsonMap> list(String sql, Object ... params) {
        ArrayList<JsonMap> result = new ArrayList<JsonMap>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            boolean check = false;
            Connection conn = this.connections.get();
            if (conn == null) {
                conn = this.getConnection();
                check = true;
            }
            if (sql == null) {
                if (conn != null) {
                    conn.close();
                }
                throw new SQLException("Null SQL statement");
            }
            ps = conn.prepareStatement(sql);
            this.fillStatement(sql, ps, params);
            rs = ps.executeQuery();
            ResultSetMetaData rsm = rs.getMetaData();
            while (rs.next()) {
                JsonMap jsonMap = JsonMap.newJsonMap();
                for (int j = 1; j <= rsm.getColumnCount(); ++j) {
                    String columnName = rsm.getColumnLabel(j);
                    Object val = rs.getObject(columnName);
                    jsonMap.set(AppConstant.HUMP ? StrCaseUtil.toCamelCase(columnName) : columnName, val);
                }
                result.add(jsonMap);
            }
            if (check) {
                this.close(conn);
            }
            this.close(rs, ps);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new SQLParamsException(e);
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
        }
        return result;
    }

    public List<JsonMap> list(String sql) {
        return this.list(sql, new Object[0]);
    }

    public List<Object> listOne(String sql, Object ... params) {
        ArrayList<Object> result = new ArrayList<Object>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            boolean check = false;
            Connection conn = this.connections.get();
            if (conn == null) {
                conn = this.getConnection();
                check = true;
            }
            if (sql == null) {
                if (conn != null) {
                    conn.close();
                }
                throw new SQLException("Null SQL statement");
            }
            ps = conn.prepareStatement(sql);
            this.fillStatement(sql, ps, params);
            rs = ps.executeQuery();
            ResultSetMetaData rsm = rs.getMetaData();
            while (rs.next()) {
                Object object = rs.getObject(rsm.getColumnLabel(1));
                result.add(object);
            }
            if (check) {
                this.close(conn);
            }
            this.close(rs, ps);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new SQLParamsException(e);
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T query(String sql, Class<T> cls, Object ... params) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        Object obj = null;
        try {
            boolean check = false;
            Connection conn = this.connections.get();
            if (conn == null) {
                conn = this.getConnection();
                check = true;
            }
            if (sql == null) {
                if (conn == null) throw new SQLException("Null SQL statement");
                conn.close();
                throw new SQLException("Null SQL statement");
            }
            ps = conn.prepareStatement(sql);
            this.fillStatement(sql, ps, params);
            rs = ps.executeQuery();
            if (rs.first()) {
                ResultSetMetaData rsm = rs.getMetaData();
                obj = cls.newInstance();
                Class<T> superclass = cls.getSuperclass();
                if (superclass.getDeclaredAnnotation(Table.class) != null) {
                    this.setColumns(rs, rsm, superclass.getDeclaredFields(), obj);
                } else {
                    this.setColumns(rs, rsm, cls.getDeclaredFields(), obj);
                }
            } else {
                obj = null;
            }
            if (check) {
                this.close(conn);
            }
            this.close(rs, ps);
            return obj;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLParamsException(e);
            catch (InstantiationException e2) {
                e2.printStackTrace();
                return obj;
            }
            catch (IllegalAccessException e3) {
                e3.printStackTrace();
                return obj;
            }
        }
        finally {
            this.close(rs, ps);
        }
    }

    public T query(String sql, Class<T> cls) {
        return this.query(sql, cls, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<T> list(String sql, Class<T> cls, Object ... params) {
        ArrayList<T> result = new ArrayList<T>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            boolean check = false;
            Connection conn = this.connections.get();
            if (conn == null) {
                conn = this.getConnection();
                check = true;
            }
            if (sql == null) {
                if (conn == null) throw new SQLException("Null SQL statement");
                conn.close();
                throw new SQLException("Null SQL statement");
            }
            ps = conn.prepareStatement(sql);
            this.fillStatement(sql, ps, params);
            rs = ps.executeQuery();
            ResultSetMetaData rsm = rs.getMetaData();
            Class<T> superclass = cls.getSuperclass();
            Table tableAnnotation = superclass.getDeclaredAnnotation(Table.class);
            while (rs.next()) {
                T obj = cls.newInstance();
                if (tableAnnotation != null) {
                    this.setColumns(rs, rsm, superclass.getDeclaredFields(), obj);
                } else {
                    this.setColumns(rs, rsm, cls.getDeclaredFields(), obj);
                }
                result.add(obj);
            }
            if (check) {
                this.close(conn);
            }
            this.close(rs, ps);
            return result;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLParamsException(e);
            catch (InstantiationException e2) {
                e2.printStackTrace();
                return result;
            }
            catch (IllegalAccessException e3) {
                e3.printStackTrace();
                return result;
            }
        }
        finally {
            this.close(rs, ps);
        }
    }

    public List<T> list(String sql, Class<T> obj) {
        return this.list(sql, obj, null);
    }

    public Page page(String sql, Integer pageIndex, Integer pageSize, Object ... params) {
        PageConditions pageConditions = new PageConditions(pageIndex, pageSize);
        pageConditions.setParams(params);
        return this.page(sql, null, pageConditions);
    }

    public Page<T> page(String sql, Class<T> cls, Integer pageIndex, Integer pageSize, Object ... params) {
        PageConditions pageConditions = new PageConditions(pageIndex, pageSize);
        pageConditions.setParams(params);
        return this.page(sql, cls, pageConditions);
    }

    public Page page(String sql, PageConditions pageConditions) {
        return this.page(sql, null, pageConditions);
    }

    public Page<T> page(String sql, Class<T> cls, PageConditions pageConditions) {
        Integer pageIndex = pageConditions.getPageNum();
        Integer pageSize = pageConditions.getPageSize();
        int page = pageIndex == null || pageIndex <= 1 ? 1 : pageIndex;
        int size = pageSize == null || pageSize < 0 ? 10 : pageSize;
        StringBuffer sb = new StringBuffer(sql);
        String orderField = pageConditions.getOrderField();
        OrderBy sortType = pageConditions.getSortType();
        if (StrUtil.notBlank(orderField) && sortType != null) {
            sb.append(" order by " + orderField + " " + (Object)((Object)sortType));
        }
        sb.append(" limit " + (page - 1) * size + "," + size);
        Object[] params = pageConditions.getParams();
        List<JsonMap> data = cls == null ? this.list(sb.toString(), params) : this.list(sb.toString(), cls, params);
        String countSql = sb.toString().toUpperCase();
        countSql = countSql.indexOf("GROUP") != -1 || sb.indexOf("DISTINCT") != -1 ? "select count(1) as count from (select count(1) " + sql.substring(sql.toUpperCase().indexOf("FROM"), sql.length()) + ") as temp" : "select count(1) as count " + sql.substring(sql.toUpperCase().indexOf("FROM"), sql.length());
        long rows = this.query(countSql, params).getLong("count");
        int total = (int)(rows / (long)size + (long)(rows % (long)size == 0L ? 0 : 1));
        if (AppConstant.DEBUG.booleanValue()) {
            logger.debug("\nSQL    : {}\nParams : {}\n", (Object)sb.toString(), params == null ? "" : JSON.toJSON((Object)params));
            logger.debug("\nSQL    : {}\nParams : {}\n", (Object)countSql, params == null ? "" : JSON.toJSON((Object)params));
        }
        return new Page<List<JsonMap>>(page, size, data, rows, total);
    }

    private void fillStatement(String sql, PreparedStatement ps, Object ... params) throws SQLException {
        if (params == null || params.length == 0) {
            return;
        }
        for (int i = 1; i <= params.length; ++i) {
            ps.setObject(i, params[i - 1]);
        }
        if (AppConstant.DEBUG.booleanValue()) {
            logger.debug("\nSQL    : {}\nParams : {}\n", (Object)sql, JSON.toJSON((Object)params));
        }
    }

    private void setColumns(ResultSet rs, ResultSetMetaData rsm, Field[] fields, Object obj) throws SQLException {
        block2: for (int j = 1; j <= rsm.getColumnCount(); ++j) {
            String columnName = rsm.getColumnLabel(j);
            Object val = rs.getObject(columnName);
            for (Field field : fields) {
                if (!StrCaseUtil.toUnderlineName(columnName).equals(StrCaseUtil.toUnderlineName(field.getName()))) continue;
                field.setAccessible(true);
                try {
                    Class<?> type = field.getType();
                    if (type == Long.class) {
                        val = rs.getLong(columnName);
                    }
                    field.set(obj, val);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                continue block2;
            }
        }
    }

    public Criteria<T> createCriteria(Class<T> cls) {
        return new Criteria<T>(cls, this);
    }

    public JsonMap findById(String statement, Object id) {
        if (!ParamTypeUtil.isBaseDataType(id.getClass())) {
            throw new RuntimeException(id + " \u4e0d\u662f\u57fa\u672c\u6570\u636e\u7c7b\u578b!");
        }
        SqlParams sqlParams = SqlStatement.getSql(statement, id);
        return this.query(sqlParams.getSql(), sqlParams.getParams());
    }

    public T findById(String statement, Class<T> cls, Object id) {
        if (!ParamTypeUtil.isBaseDataType(id.getClass())) {
            throw new RuntimeException(id + " \u4e0d\u662f\u57fa\u672c\u6570\u636e\u7c7b\u578b!");
        }
        SqlParams sqlParams = SqlStatement.getSql(statement, id);
        return this.query(sqlParams.getSql(), cls, sqlParams.getParams());
    }

    public JsonMap find(String statement, Map params) {
        SqlParams sqlParams = SqlStatement.getSql(statement, params);
        return this.query(sqlParams.getSql(), sqlParams.getParams());
    }

    public T find(String statement, Class<T> cls, Map params) {
        SqlParams sqlParams = SqlStatement.getSql(statement, params);
        return this.query(sqlParams.getSql(), cls, sqlParams.getParams());
    }

    public List<JsonMap> findList(String statement, Map params) {
        SqlParams sqlParams = SqlStatement.getSql(statement, params);
        return this.list(sqlParams.getSql(), sqlParams.getParams());
    }

    public List<JsonMap> findList(String statement) {
        return this.findList(statement, null);
    }

    public List<T> findList(String statement, Class<T> cls, Map params) {
        SqlParams sqlParams = SqlStatement.getSql(statement, params);
        return this.list(sqlParams.getSql(), cls, sqlParams.getParams());
    }

    public Page findPage(String statement, Integer index, Integer size, Map params) {
        SqlParams sqlParams = SqlStatement.getSql(statement, params);
        return this.page(sqlParams.getSql(), index, size, sqlParams.getParams());
    }

    public Page<T> findPage(String statement, Integer index, Integer size) {
        return this.findPage(statement, index, size, null);
    }

    public Page<T> findPage(String statement, Class<T> cls, Integer index, Integer size, Map params) {
        SqlParams sqlParams = SqlStatement.getSql(statement, params);
        return this.page(sqlParams.getSql(), cls, index, size, sqlParams.getParams());
    }

    public void save(String statement, Map params) {
        SqlParams sqlParams = SqlStatement.getSql(statement, params);
        this.insert(sqlParams.getSql(), sqlParams.getParams());
    }

    public Long saveReturnKey(String statement, Map params) {
        SqlParams sqlParams = SqlStatement.getSql(statement, params);
        return this.insertReturnKey(sqlParams.getSql(), sqlParams.getParams());
    }

    public int updateById(String statement, Object id) {
        SqlParams sqlParams = SqlStatement.getSql(statement, id);
        return this.update(sqlParams.getSql(), sqlParams.getParams());
    }

    public int updateZ(String statement, Map params) {
        SqlParams sqlParams = SqlStatement.getSql(statement, params);
        return this.update(sqlParams.getSql(), sqlParams.getParams());
    }

    public int updateZ(String statement) {
        return this.updateZ(statement, null);
    }
}

