/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.sqlmap;

import cn.jants.common.enums.StartMode;
import cn.jants.common.utils.PathUtil;
import cn.jants.core.context.AppConstant;
import cn.jants.core.ext.Plugin;
import cn.jants.plugin.sqlmap.SqlParser;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SqlMapPlugin
implements Plugin {
    private static final Logger logger = LoggerFactory.getLogger(SqlMapPlugin.class);
    private String dirPath;
    private static DocumentBuilder documentBuilder;

    public SqlMapPlugin(String dirPath) {
        this.dirPath = dirPath;
    }

    @Override
    public boolean start() throws IOException, SAXException {
        SqlParser.clear();
        logger.debug("\u521d\u59cb\u5316[XML SQL] \u6587\u4ef6 ...");
        if (PathUtil.isJarMode()) {
            AppConstant.START_MODE = StartMode.JAR;
        } else {
            File dirFile = new File(PathUtil.getClassPath().concat(this.dirPath));
            if (dirFile.isDirectory()) {
                File[] files;
                for (File file : files = dirFile.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith(".xml");
                    }
                })) {
                    Document document = documentBuilder.parse(file);
                    SqlParser.parse(document);
                    logger.debug("\u8bfb\u53d6 {} \u6210\u529f ...", (Object)file.getPath());
                }
                logger.debug("[XML SQL] \u521d\u59cb\u5316\u5b8c\u6210 ...");
            }
        }
        return true;
    }

    @Override
    public boolean destroy() {
        SqlParser.clear();
        return true;
    }

    static {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("I don`t know .", ex);
        }
    }
}

