/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.sqlmap;

import cn.jants.core.utils.ParamTypeUtil;
import cn.jants.plugin.sqlmap.SqlParams;
import cn.jants.plugin.sqlmap.TagElement;
import cn.jants.plugin.sqlmap.node.ChooseSqlNode;
import cn.jants.plugin.sqlmap.node.ForEachSqlNode;
import cn.jants.plugin.sqlmap.node.IfSqlNode;
import cn.jants.plugin.sqlmap.node.IncludeSqlNode;
import cn.jants.plugin.sqlmap.node.SetSqlNode;
import cn.jants.plugin.sqlmap.node.SqlNode;
import cn.jants.plugin.sqlmap.node.TextSqlNode;
import cn.jants.plugin.sqlmap.node.TrimSqlNode;
import cn.jants.plugin.sqlmap.node.WhereSqlNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SqlParser {
    protected static Map<String, TagElement> sqlMap = new ConcurrentHashMap<String, TagElement>();
    protected static Map<String, String> resultTypeMap = new ConcurrentHashMap<String, String>();
    private static final String STATIC_START_SYMBOL = "#{";
    private static final String STATIC_END_SYMBOL = "}";
    private static final String[] OPTIONS = new String[]{"resultType", "sql", "select", "insert", "update", "delete"};

    public static void parse(Document document) {
        Element documentElement = document.getDocumentElement();
        if ("mapper".equals(documentElement.getTagName())) {
            String rootName = documentElement.getAttribute("namespace");
            if (rootName.isEmpty()) {
                throw new RuntimeException("the namespace domain must be defined!");
            }
            for (String option : OPTIONS) {
                NodeList nodeList = documentElement.getElementsByTagName(option);
                if ("resultType".equals(option)) {
                    SqlParser.addResultType(rootName, nodeList);
                    continue;
                }
                SqlParser.addTagElement(option, rootName, nodeList);
            }
        }
    }

    private static void addResultType(String rootName, NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node item = nodeList.item(i);
            String key = rootName + "." + ((Element)item).getAttribute("id");
            String type = ((Element)item).getAttribute("type");
            resultTypeMap.put(key, type);
        }
    }

    private static void addTagElement(String type, String rootName, NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node item = nodeList.item(i);
            String key = rootName + "." + ((Element)item).getAttribute("id");
            String resultType = ((Element)item).getAttribute("resultType");
            NodeList childNodes = item.getChildNodes();
            ArrayList<SqlNode> nodes = new ArrayList<SqlNode>();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node it = childNodes.item(j);
                if (it.getNodeType() == 3) {
                    nodes.add(new TextSqlNode(it.getTextContent()));
                    continue;
                }
                String nodeName = it.getNodeName();
                if (nodeName == "include") {
                    String refid = ((Element)it).getAttribute("refid");
                    String includeKey = rootName + "." + refid;
                    TagElement tagElement = sqlMap.get(includeKey);
                    if (tagElement == null) {
                        throw new RuntimeException(String.format("not found %s !", includeKey));
                    }
                    List<SqlNode> sqlNodes = tagElement.getSqlNodeList();
                    if (sqlNodes == null || sqlNodes.size() == 0) {
                        throw new RuntimeException(includeKey + " the includ reference node must exist or can only be configured in the front!");
                    }
                    nodes.add(new IncludeSqlNode(sqlNodes.get(0)));
                    continue;
                }
                if (nodeName == "if") {
                    nodes.add(new IfSqlNode(it));
                    continue;
                }
                if (nodeName == "where") {
                    nodes.add(new WhereSqlNode(it));
                    continue;
                }
                if (nodeName == "set") {
                    nodes.add(new SetSqlNode(it));
                    continue;
                }
                if (nodeName == "trim") {
                    nodes.add(new TrimSqlNode(it));
                    continue;
                }
                if (nodeName == "choose") {
                    nodes.add(new ChooseSqlNode(it));
                    continue;
                }
                if (nodeName != "foreach") continue;
                nodes.add(new ForEachSqlNode(it));
            }
            sqlMap.put(key, new TagElement(type, resultType, nodes));
        }
    }

    public static SqlParams getPreparedStatement(String key, Object params) {
        TagElement tagElement = sqlMap.get(key);
        List<SqlNode> sqlNodes = tagElement.getSqlNodeList();
        if (sqlNodes == null || sqlNodes.size() == 0) {
            throw new IllegalArgumentException("not find " + key + "!");
        }
        StringBuffer sb = new StringBuffer();
        for (SqlNode sqlNode : sqlNodes) {
            sb.append(sqlNode.getResult(params));
        }
        String sql = sb.toString().replaceAll("\r|\n|\t|", "").replaceAll(" +", " ").trim();
        if (params == null) {
            return new SqlParams(sql, null);
        }
        if (ParamTypeUtil.isBaseDataType(params.getClass())) {
            int startNum = sql.indexOf(STATIC_START_SYMBOL);
            if (startNum == -1) {
                return new SqlParams(sql, null);
            }
            sql = sql.substring(0, startNum).concat("?");
            return new SqlParams(sql, new Object[]{params});
        }
        if (params instanceof Map) {
            List<String> fieldList = SqlParser.getFieldList(sql);
            Map mapParams = (Map)params;
            ArrayList values = new ArrayList(mapParams.size());
            for (String filed : fieldList) {
                if (!mapParams.containsKey(filed)) continue;
                Object val = mapParams.get(filed);
                sql = sql.replace(STATIC_START_SYMBOL.concat(filed).concat(STATIC_END_SYMBOL), "? ");
                values.add(val);
            }
            return new SqlParams(sql, values.toArray());
        }
        throw new IllegalArgumentException("[" + params + "] \u4f20\u5165\u7684\u6570\u636e\u5bf9\u8c61\u5fc5\u987bMap\u7c7b\u578b \u6216\u57fa\u672c\u6570\u636e\u7c7b\u578b!");
    }

    public static SqlParams getPreparedStatement(String key) {
        return SqlParser.getPreparedStatement(key, null);
    }

    public static String getResultType(String key) {
        return resultTypeMap.get(key);
    }

    public static void clear() {
        sqlMap.clear();
    }

    public static TagElement getOptionType(String key) {
        TagElement tagElement = sqlMap.get(key);
        List<SqlNode> sqlNodes = tagElement.getSqlNodeList();
        if (sqlNodes == null || sqlNodes.size() == 0) {
            throw new IllegalArgumentException("not find " + key + "!");
        }
        return tagElement;
    }

    private static List<String> getFieldList(String sql) {
        ArrayList<String> list = new ArrayList<String>();
        while (sql.indexOf(STATIC_START_SYMBOL) != -1) {
            int sNum = sql.indexOf(STATIC_START_SYMBOL);
            int eNum = sql.indexOf(STATIC_END_SYMBOL, sNum);
            String str = sql.substring(sNum + 2, eNum);
            sql = sql.replace(STATIC_START_SYMBOL + str + STATIC_END_SYMBOL, "");
            list.add(str);
        }
        return list;
    }
}

