/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.tool;

import cn.jants.common.bean.Log;
import cn.jants.common.bean.Prop;
import cn.jants.common.utils.HttpUtil;
import cn.jants.core.holder.ClientHolder;
import cn.jants.plugin.weixin.SnsApi;
import cn.jants.plugin.weixin.WxUserMap;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;

public class WxOauth2Tool {
    private String appId;
    private String appSecret;
    private static final ConcurrentMap<String, WxOauth2Tool> OAUTH_MAP = new ConcurrentHashMap<String, WxOauth2Tool>();

    private WxOauth2Tool(String appId, String appSecret) {
        this.appId = appId;
        this.appSecret = appSecret;
    }

    public static WxOauth2Tool init(String appId, String appSecret) {
        appId = Prop.getKeyStrValue(appId);
        appSecret = Prop.getKeyStrValue(appSecret);
        String key = appId.concat("_").concat(appSecret);
        if (OAUTH_MAP.containsKey(key)) {
            return (WxOauth2Tool)OAUTH_MAP.get(key);
        }
        WxOauth2Tool wxOauth2Tool = new WxOauth2Tool(appId, appSecret);
        OAUTH_MAP.put(key, wxOauth2Tool);
        return wxOauth2Tool;
    }

    public String getOauth2Url(SnsApi scope) {
        String oauth2Url;
        HttpServletRequest request = ClientHolder.getRequest();
        StringBuffer sbUrl = new StringBuffer();
        sbUrl.append("http://" + request.getServerName() + request.getContextPath() + request.getServletPath());
        try {
            String enUrl = URLEncoder.encode(sbUrl.toString(), "utf-8");
            oauth2Url = String.format("https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=STATE#wechat_redirect", this.appId, enUrl, scope.getType());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException("url\u7f16\u7801\u8f6c\u6362\u5f02\u5e38!");
        }
        return oauth2Url;
    }

    public JSONObject getAccessTokenStr(String code) {
        String oauth2UrlStr = String.format("https://api.weixin.qq.com/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code", this.appId, this.appSecret, code);
        String responseStr = HttpUtil.sendGet(oauth2UrlStr);
        Log.debug("\u57fa\u672c\u6388\u6743\u8fd4\u56de\u6570\u636e >> {} ", responseStr);
        return JSON.parseObject((String)responseStr);
    }

    public WxUserMap getUserInfo(String code) {
        JSONObject result = this.getAccessTokenStr(code);
        String accessToken = result.getString("access_token");
        String openId = result.getString("openid");
        String userInfoUrlStr = String.format("https://api.weixin.qq.com/sns/userinfo?access_token=%s&openid=%s&lang=zh_CN", accessToken, openId);
        String responseStr = HttpUtil.sendGet(userInfoUrlStr);
        Log.debug("\u83b7\u53d6\u57fa\u672c\u7528\u6237\u6570\u636e >> {} ", responseStr);
        return new WxUserMap((Map)JSON.parseObject((String)responseStr));
    }
}

