/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.tool;

import cn.jants.common.bean.Log;
import cn.jants.common.bean.Prop;
import cn.jants.common.utils.HttpUtil;
import cn.jants.common.utils.IOUtil;
import cn.jants.common.utils.MapXmlUtil;
import cn.jants.common.utils.StrUtil;
import cn.jants.core.holder.ClientHolder;
import cn.jants.plugin.pay.wx.Sign;
import cn.jants.plugin.pay.wx.WxNotifyResult;
import cn.jants.plugin.pay.wx.WxPayApiResult;
import cn.jants.plugin.pay.wx.WxPayParams;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;

public class WxPayTool {
    private String appId;
    private String mchId;
    private String payKey;
    private String notifyUrl;
    private static final ConcurrentMap<String, WxPayTool> PAY_MAP = new ConcurrentHashMap<String, WxPayTool>();

    private WxPayTool(String appId, String mchId, String payKey, String notifyUrl) {
        this.appId = appId;
        this.mchId = mchId;
        this.payKey = payKey;
        this.notifyUrl = notifyUrl;
    }

    public static WxPayTool init(String appId, String mchId, String payKey, String notifyUrl) {
        appId = Prop.getKeyStrValue(appId);
        mchId = Prop.getKeyStrValue(mchId);
        payKey = Prop.getKeyStrValue(payKey);
        notifyUrl = Prop.getKeyStrValue(notifyUrl);
        if (PAY_MAP.containsKey(appId)) {
            return (WxPayTool)PAY_MAP.get(appId);
        }
        WxPayTool wxPayTool = new WxPayTool(appId, mchId, payKey, notifyUrl);
        PAY_MAP.put(appId, wxPayTool);
        return wxPayTool;
    }

    public WxPayApiResult getAppPaySign(WxPayParams params) {
        WxPayApiResult unifiedOrderParams = this.unifiedOrderParams(params);
        String prepayId = unifiedOrderParams.getStr("prepay_id");
        String timeStamp = Long.toString(System.currentTimeMillis() / 1000L);
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("appid", this.appId);
        result.put("partnerid", this.mchId);
        result.put("package", "Sign=WXPay");
        result.put("noncestr", StrUtil.randomUUID());
        result.put("prepayid", prepayId);
        result.put("timestamp", timeStamp);
        result.put("sign", Sign.md5Sign(result, this.payKey));
        WxPayApiResult payApiResult = new WxPayApiResult(result);
        payApiResult.set("prepay_id", prepayId);
        return payApiResult;
    }

    public WxPayApiResult getJsApiPaySign(WxPayParams params) {
        WxPayApiResult unifiedOrderParams = this.unifiedOrderParams(params);
        String prepayId = unifiedOrderParams.getStr("prepay_id");
        String timeStamp = Long.toString(System.currentTimeMillis() / 1000L);
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("appId", this.appId);
        result.put("nonceStr", StrUtil.randomUUID());
        result.put("package", "prepay_id=" + prepayId);
        result.put("signType", "MD5");
        result.put("timeStamp", timeStamp);
        result.put("paySign", Sign.md5Sign(result, this.payKey));
        result.put("prepayId", prepayId);
        WxPayApiResult payApiResult = new WxPayApiResult(result);
        payApiResult.set("prepay_id", prepayId);
        return payApiResult;
    }

    public WxPayApiResult getScanCodePaySign(WxPayParams params) {
        return this.unifiedOrderParams(params);
    }

    public String createPayCodeUrl(String productId) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("product_id", productId);
        params.put("appid", this.appId);
        params.put("mch_id", this.mchId);
        params.put("time_stamp", Long.toString(System.currentTimeMillis() / 1000L));
        params.put("nonce_str", StrUtil.randomUUID());
        params.put("sign", Sign.md5Sign(params, this.payKey));
        return "weixin://wxpay/bizpayurl?" + Sign.pj(params);
    }

    public Map orderQuery(String id, int type) {
        WxPayParams params = WxPayParams.newPayParams().setAppId(this.appId).setMchId(this.mchId).setNonceStr(StrUtil.randomUUID()).setOutTradeNo(id);
        params.setSign(Sign.md5Sign(params, this.payKey));
        String xml = MapXmlUtil.map2Xml(params, "xml");
        String url = "https://api.mch.weixin.qq.com/pay/orderquery";
        if (type == 1) {
            url = "https://api.mch.weixin.qq.com/pay/closeorder";
        } else if (type == 2) {
            url = "https://api.mch.weixin.qq.com/pay/refundquery";
        }
        String responseXml = HttpUtil.sendPost(url, xml);
        return MapXmlUtil.xml2Map(responseXml, "xml");
    }

    public WxNotifyResult getNotify() {
        try {
            HttpServletRequest request = ClientHolder.getRequest();
            String xmlStr = IOUtil.parseStr((InputStream)request.getInputStream());
            return new WxNotifyResult(MapXmlUtil.xml2Map(xmlStr, "xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private WxPayApiResult unifiedOrderParams(WxPayParams params) {
        params.setAppId(this.appId).setMchId(this.mchId).setNonceStr(StrUtil.randomUUID()).setNotifyUrl(this.notifyUrl);
        String orderXml = this.unifiedOrderXml(params);
        Log.debug("\u7edf\u4e00\u8ba2\u5355XML > {}", orderXml);
        String responseXml = HttpUtil.sendPost("https://api.mch.weixin.qq.com/pay/unifiedorder", orderXml);
        Map unifiedOrderParams = MapXmlUtil.xml2Map(String.valueOf(responseXml), "xml");
        return new WxPayApiResult(unifiedOrderParams);
    }

    private String unifiedOrderXml(WxPayParams params) {
        String md5Sign = Sign.md5Sign(params, this.payKey);
        params.put("sign", md5Sign);
        return MapXmlUtil.map2Xml(params, "xml");
    }
}

