/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.restful.matcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

public class StringUtils {
    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return StringUtils.toStringArray(tokens);
    }

    public static String[] toStringArray(Collection<String> collection) {
        return collection == null ? null : collection.toArray(new String[collection.size()]);
    }

    public static boolean hasText(CharSequence str) {
        if (!StringUtils.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasText(String str) {
        return StringUtils.hasText((CharSequence)str);
    }

    public static String arrayToDelimitedString(Object[] arr, String delim) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        if (arr.length == 1) {
            return StringUtils.nullSafeToString(arr[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static String nullSafeToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Object[]) {
            return StringUtils.nullSafeToString((Object[])obj);
        }
        if (obj instanceof boolean[]) {
            return StringUtils.nullSafeToString((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return StringUtils.nullSafeToString((byte[])obj);
        }
        if (obj instanceof char[]) {
            return StringUtils.nullSafeToString((char[])obj);
        }
        if (obj instanceof double[]) {
            return StringUtils.nullSafeToString((double[])obj);
        }
        if (obj instanceof float[]) {
            return StringUtils.nullSafeToString((float[])obj);
        }
        if (obj instanceof int[]) {
            return StringUtils.nullSafeToString((int[])obj);
        }
        if (obj instanceof long[]) {
            return StringUtils.nullSafeToString((long[])obj);
        }
        if (obj instanceof short[]) {
            return StringUtils.nullSafeToString((short[])obj);
        }
        String str = obj.toString();
        return str != null ? str : "";
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }
}

