/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.common.bean;

import cn.jants.common.bean.Log;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class JsonMap
extends HashMap {
    public JsonMap() {
    }

    public JsonMap(Object javaObject) {
        if (javaObject != null) {
            JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)javaObject);
            this.putAll(jsonObject);
        }
    }

    public static <K, V> JsonMap newJsonMap() {
        return new JsonMap();
    }

    public <T> T toJavaObject(Class<T> cls) {
        JSON jsonMap = (JSON)JSON.toJSON((Object)this);
        return (T)JSON.toJavaObject((JSON)jsonMap, cls);
    }

    public String toJsonString() {
        return JSON.toJSONString((Object)this);
    }

    public JsonMap set(Object key, Object value) {
        this.put(key, value);
        return this;
    }

    public String getStr(String key) {
        String val = String.valueOf(this.get(key));
        if (val == null || "".equals(val)) {
            return val;
        }
        return val.trim();
    }

    public String getStr(String key, String defaultValue) {
        return this.get(key) == null ? defaultValue : String.valueOf(this.get(key));
    }

    public Integer getInt(String key) {
        return Integer.parseInt(String.valueOf(this.get(key)));
    }

    public Integer getInt(String key, Integer defaultValue) {
        return this.get(key) == null ? defaultValue : Integer.parseInt(String.valueOf(this.get(key)));
    }

    public Long getLong(String key) {
        return Long.parseLong(String.valueOf(this.get(key)));
    }

    public Long getLong(String key, Long defaultValue) {
        return this.get(key) == null ? defaultValue : Long.parseLong(String.valueOf(this.get(key)));
    }

    public Boolean getBoolean(String key) {
        return Boolean.parseBoolean(String.valueOf(this.get(key)));
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.get(key) == null ? defaultValue : Boolean.parseBoolean(String.valueOf(this.get(key)));
    }

    public Date getDate(String key, String formatStr) {
        SimpleDateFormat df = new SimpleDateFormat(formatStr);
        try {
            return df.parse(this.getStr(key));
        }
        catch (ParseException e) {
            Log.error("Date class transition anomaly.", new Object[0]);
            return null;
        }
    }

    public BigDecimal getBigDecimal(String key) {
        return new BigDecimal(this.getStr(key));
    }

    @Override
    public Object put(Object key, Object value) {
        if (value == null) {
            return super.put(key, "");
        }
        return super.put(key, value);
    }
}

