/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.common.utils;

import java.util.UUID;

public class StrUtil {
    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpperCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        if (len == 0) {
            return true;
        }
        block3: for (int i = 0; i < len; ++i) {
            switch (str.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean notBlank(String str) {
        return !StrUtil.isBlank(str);
    }

    public static boolean notBlank(String ... strings) {
        if (strings == null) {
            return false;
        }
        for (String str : strings) {
            if (!StrUtil.isBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean notNull(Object ... paras) {
        if (paras == null) {
            return false;
        }
        for (Object obj : paras) {
            if (obj != null) continue;
            return false;
        }
        return true;
    }

    public static String join(Object[] stringArray, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(stringArray[i]);
        }
        return sb.toString();
    }

    public static String joinLastSuffix(String str, String suffix) {
        if (str == null) {
            return null;
        }
        int num = str.lastIndexOf(suffix);
        if (num + 1 == str.length()) {
            return str;
        }
        return str.concat(suffix);
    }

    public static String join(Object[] stringArray, String separator, int num) {
        StringBuilder sb = new StringBuilder();
        for (int i = num; i < stringArray.length; ++i) {
            sb.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String randomUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String lastSubstring(String str, char separator, int num) {
        return str.substring(StrUtil.getSubIndex(str, separator, num) + 1, str.length());
    }

    public static String substring(String str, char separator, int num) {
        return str.substring(0, StrUtil.getSubIndex(str, separator, num));
    }

    private static int getSubIndex(String str, char separator, int num) {
        int j = 0;
        int k = 0;
        for (int i = str.length() - 1; i >= 0; --i) {
            char[] chars = str.toCharArray();
            if (chars[i] != separator) continue;
            if (num - 1 == j) {
                k = i;
            }
            ++j;
        }
        return k;
    }

    public static String setFirstInitial(String str, Character separator) {
        char initial = str.toCharArray()[0];
        if (initial == separator.charValue()) {
            return str;
        }
        return "/" + str;
    }

    public static String delFirstInitial(String str, Character separator) {
        char initial = str.toCharArray()[0];
        if (initial != separator.charValue()) {
            return str;
        }
        return str.substring(1);
    }

    public static String setLastInitial(String str, Character separator) {
        char initial = str.toCharArray()[str.length() - 1];
        if (initial == separator.charValue()) {
            return str;
        }
        return str + separator;
    }

    public static int count(String str, String content) {
        int count = 0;
        while (content.indexOf(str) != -1) {
            int i = content.indexOf(str);
            content = content.substring(i + 1, content.length() - 1);
            ++count;
        }
        return count;
    }
}

