/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.context;

import cn.jants.common.bean.Log;
import cn.jants.common.utils.StrUtil;
import cn.jants.core.context.AntsContext;
import cn.jants.core.context.AppConstant;
import cn.jants.core.module.Constant;
import cn.jants.core.module.HandlerManager;
import cn.jants.core.module.RequestMappingManager;
import cn.jants.restful.request.MappingMatch;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AntsFilter
implements Filter {
    private Constant constant;
    private HandlerManager handlerManager;
    private int contextPathLength;
    private AntsContext context;

    public void init(FilterConfig filterConfig) throws ServletException {
        String configClass = filterConfig.getInitParameter("loadClass");
        if (configClass == null) {
            throw new RuntimeException("\u8bf7\u5728 web.xml \u6587\u4ef6\u4e2d\u914d\u7f6e\u542f\u52a8\u7c7b!");
        }
        try {
            Class<?> temp = Class.forName(configClass);
            ServletContext servletContext = filterConfig.getServletContext();
            this.context = new AntsContext(temp, servletContext);
            this.handlerManager = this.context.getHandlerManager();
            this.constant = this.context.getConstant();
            String contextPath = servletContext.getContextPath();
            this.contextPathLength = contextPath == null || "/".equals(contextPath) ? 0 : contextPath.length();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("\u52a0\u8f7d".concat(configClass) + " \u5931\u8d25!");
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        request.setCharacterEncoding(this.constant.getEncoding());
        response.setCharacterEncoding(this.constant.getEncoding());
        String target = request.getRequestURI();
        if (this.contextPathLength > 0) {
            target = target.substring(this.contextPathLength);
        }
        String[] resources = this.constant.getResources();
        boolean[] isHandled = new boolean[]{false};
        if (StrUtil.notBlank(resources)) {
            for (String resource : resources) {
                if (!target.startsWith(resource)) continue;
                isHandled[0] = true;
                break;
            }
        }
        if (isHandled[0] || !MappingMatch.matchRequests(RequestMappingManager.getRequests(), target)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            boolean execute;
            if (StrUtil.notBlank(AppConstant.DOMAIN)) {
                response.setHeader("Access-Control-Allow-Origin", AppConstant.DOMAIN);
                response.setHeader("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE");
            }
            if (execute = this.handlerManager.execute(target, request, response)) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    public void destroy() {
        Log.debug("\u9500\u6bc1\u6240\u6709\u63d2\u4ef6...", new Object[0]);
        this.context.stopPlugins();
    }
}

