/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.handler;

import cn.jants.common.annotation.action.NoCheckSignature;
import cn.jants.common.bean.Log;
import cn.jants.common.enums.ResponseCode;
import cn.jants.common.exception.TipException;
import cn.jants.common.utils.StrEncryptUtil;
import cn.jants.common.utils.StrUtil;
import cn.jants.core.ext.Handler;
import cn.jants.core.module.RequestMappingManager;
import cn.jants.restful.request.MappingMatch;
import cn.jants.restful.request.RequestMappingBean;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.AnnotationUtils;

public class SignatureHandler
implements Handler {
    private String secretKey = "&2018";
    private String signName = "sign";
    private String effTimeName = "timeStamp";
    private Long effTime = null;
    private final List<RequestMappingBean> requestMappingManager = RequestMappingManager.getRequestMappingManager();

    public SignatureHandler() {
    }

    public SignatureHandler(String secretKey) {
        this.secretKey = secretKey;
    }

    public SignatureHandler(Long effTime) {
        this.effTime = effTime;
    }

    public SignatureHandler(String secretKey, Long effTime) {
        this.secretKey = secretKey;
        this.effTime = effTime;
    }

    @Override
    public boolean preHandler(String target, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RequestMappingBean bean = MappingMatch.match(this.requestMappingManager, target);
        if (bean == null) {
            return true;
        }
        Method method = bean.getMethod();
        NoCheckSignature noCheckSignature = (NoCheckSignature)AnnotationUtils.findAnnotation((Method)method, NoCheckSignature.class);
        if (noCheckSignature == null) {
            this.checkSignature(request);
        }
        return true;
    }

    private void checkSignature(HttpServletRequest request) {
        long l;
        String reqSignStr = request.getParameter(this.signName);
        Log.debug("\u8bf7\u6c42\u7b7e\u540d request sign - > {}", reqSignStr);
        if (StrUtil.isBlank(reqSignStr)) {
            throw new TipException(ResponseCode.SING_ERROR);
        }
        Enumeration parameterNames = request.getParameterNames();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        while (parameterNames.hasMoreElements()) {
            String key = (String)parameterNames.nextElement();
            if (key.equals(this.signName)) continue;
            treeMap.put(key, request.getParameter(key));
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry entry : treeMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            sb.append(key.concat("=").concat(value).concat("&"));
        }
        sb.append(this.secretKey);
        String serSignStr = StrEncryptUtil.md5(sb.toString());
        Log.debug("\u670d\u52a1\u7b7e\u540d server sign - > {}", serSignStr);
        if (!serSignStr.equalsIgnoreCase(reqSignStr)) {
            throw new TipException(ResponseCode.SING_ERROR);
        }
        String timeStamp = request.getParameter(this.effTimeName);
        if (timeStamp != null && (l = System.currentTimeMillis() - Long.valueOf(timeStamp)) > this.effTime) {
            throw new TipException(ResponseCode.REQUEST_INVALID_ERROR);
        }
    }
}

