/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.sqlmap.node;

import cn.jants.plugin.sqlmap.node.IfSqlNode;
import cn.jants.plugin.sqlmap.node.SqlNode;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TrimSqlNode
implements SqlNode {
    private String prefix;
    private String suffix;
    private String suffixOverrides;
    private List<IfSqlNode> ifSqlNodeList = new ArrayList<IfSqlNode>();

    public TrimSqlNode(Node node) {
        Element el = (Element)node;
        this.prefix = el.getAttribute("prefix");
        this.suffix = el.getAttribute("suffix");
        this.suffixOverrides = el.getAttribute("suffixOverrides");
        NodeList childNodes = el.getElementsByTagName("if");
        if (childNodes.getLength() == 0) {
            throw new RuntimeException("configuring the trim tag must include configuring the if tag!");
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            this.ifSqlNodeList.add(new IfSqlNode(item));
        }
    }

    @Override
    public String getResult(Object obj) {
        StringBuffer sb = new StringBuffer(this.prefix);
        String sbx = "";
        for (IfSqlNode ifSqlNode : this.ifSqlNodeList) {
            String result = ifSqlNode.getResult(obj);
            if (result.isEmpty()) continue;
            if (result.indexOf(this.suffixOverrides) == -1) {
                result = result + this.suffixOverrides;
            }
            sbx = sbx + result;
        }
        if (!sbx.isEmpty()) {
            sbx = sbx.substring(0, sbx.length() - 1);
        }
        sb.append(sbx + this.suffix);
        return sb.toString();
    }
}

