/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.template;

import cn.jants.common.annotation.boot.ViewConfiguration;
import cn.jants.common.bean.JsonMap;
import cn.jants.common.enums.LoadType;
import cn.jants.restful.render.ModelAndView;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.core.resource.FileResourceLoader;

public class BeetleTpl {
    public Configuration configuration;
    private GroupTemplate groupTemplate;
    private String tplDir;

    public BeetleTpl(ViewConfiguration viewConfiguration) {
        this.tplDir = viewConfiguration.loadPath();
        try {
            Configuration configuration = Configuration.defaultConfiguration();
            this.groupTemplate = viewConfiguration.loadType() == LoadType.FilePath ? new GroupTemplate((ResourceLoader)new FileResourceLoader(viewConfiguration.loadPath()), configuration) : new GroupTemplate((ResourceLoader)new ClasspathResourceLoader(this.tplDir), configuration);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setTplDir(String tplDir) {
        this.groupTemplate.setResourceLoader((ResourceLoader)new ClasspathResourceLoader(tplDir));
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public GroupTemplate getGroupTemplate() {
        return this.groupTemplate;
    }

    private void render(String viewName, ModelAndView modelAndView, HttpServletRequest request, HttpServletResponse response) {
        Template template = null;
        Enumeration attributeNames = request.getAttributeNames();
        JsonMap model = JsonMap.newJsonMap();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            model.put(attributeName, request.getAttribute(attributeName));
        }
        if (viewName != null) {
            template = this.groupTemplate.getTemplate(viewName);
        } else if (modelAndView != null) {
            template = this.groupTemplate.getTemplate(modelAndView.getView());
            model.putAll(modelAndView.getModel());
        }
        try {
            template.binding((Map)model);
            template.renderTo((Writer)response.getWriter());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void render(String viewName, HttpServletRequest request, HttpServletResponse response) {
        this.render(viewName, null, request, response);
    }

    public void render(ModelAndView modelAndView, HttpServletRequest request, HttpServletResponse response) {
        this.render(null, modelAndView, request, response);
    }
}

