/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.tool;

import cn.jants.common.bean.JsonMap;
import cn.jants.common.enums.ResponseCode;
import cn.jants.common.exception.TipException;
import cn.jants.common.utils.HttpUtil;
import cn.jants.common.utils.IOUtil;
import cn.jants.plugin.weixin.TokenCache;
import com.alibaba.fastjson.JSON;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.net.util.Base64;

public class BaiDuContentTool {
    private String ak;
    private String sk;
    private final String TEXT_VERIFY_URL = "https://aip.baidubce.com/rest/2.0/antispam/v2/spam";
    private final String IMAGE_VERIFY_URL = "https://aip.baidubce.com/api/v1/solution/direct/img_censor";
    private final String ACCESS_TOKEN_URL = "https://aip.baidubce.com/oauth/2.0/token?grant_type=client_credentials&client_id=%s&client_secret=%s";
    private TokenCache tokenCache = new TokenCache();
    private static final ConcurrentMap<String, BaiDuContentTool> BDT_MAP = new ConcurrentHashMap<String, BaiDuContentTool>();

    public BaiDuContentTool(String ak, String sk) {
        this.ak = ak;
        this.sk = sk;
    }

    public static BaiDuContentTool init(String ak, String sk) {
        String key = ak.concat("_").concat(sk);
        if (BDT_MAP.containsKey(key)) {
            return (BaiDuContentTool)BDT_MAP.get(key);
        }
        BaiDuContentTool baiDuContentTool = new BaiDuContentTool(ak, sk);
        BDT_MAP.put(key, baiDuContentTool);
        return baiDuContentTool;
    }

    private String getAccessToken(String ak, String sk) {
        Long expires = this.tokenCache.getExpires();
        long currentTime = System.currentTimeMillis();
        if (expires == null || currentTime - expires > 2160000000L) {
            String resp = HttpUtil.sendGet(String.format("https://aip.baidubce.com/oauth/2.0/token?grant_type=client_credentials&client_id=%s&client_secret=%s", ak, sk));
            JsonMap jsonMap = (JsonMap)JSON.parseObject((String)resp, JsonMap.class);
            String accessTokenStr = jsonMap.getStr("access_token");
            this.tokenCache.setTokenCache(accessTokenStr, currentTime);
            return accessTokenStr;
        }
        return this.tokenCache.getToken();
    }

    public void textVerify(String text, boolean spam) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("content", text);
        params.put("access_token", this.getAccessToken(this.ak, this.sk));
        String resp = HttpUtil.sendPost("https://aip.baidubce.com/rest/2.0/antispam/v2/spam", params);
        JsonMap jsonMap = (JsonMap)JSON.parseObject((String)resp, JsonMap.class);
        if (jsonMap.get("error_code") != null) {
            throw new TipException(ResponseCode.UNKNOWN_ERROR.getCode(), "baidu api \u8c03\u7528\u5931\u8d25 -> " + jsonMap.getStr("error_msg"));
        }
        Map res = (Map)jsonMap.get("result");
        Integer yz = Integer.valueOf(res.get("spam") + "");
        if (spam ? yz > 0 : yz == 1) {
            throw new TipException(ResponseCode.CONTENT_GARBAGE_INFO);
        }
    }

    public void textVerify(String text) {
        this.textVerify(text, true);
    }

    public void imageVerify(InputStream in) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>(2);
        ByteArrayOutputStream data = IOUtil.parse(in);
        params.put("image", new String(Base64.encodeBase64((byte[])data.toByteArray())));
        params.put("access_token", this.getAccessToken(this.ak, this.sk));
        params.put("scenes", (String)new String[]{"webimage"});
        String resp = HttpUtil.sendPost("https://aip.baidubce.com/api/v1/solution/direct/img_censor", params);
        JsonMap jsonMap = (JsonMap)JSON.parseObject((String)resp, JsonMap.class);
        if (jsonMap.get("error_code") != null) {
            throw new TipException(ResponseCode.UNKNOWN_ERROR.getCode(), "baidu api \u8c03\u7528\u5931\u8d25 -> " + jsonMap.getStr("error_msg"));
        }
        Integer conclusionType = jsonMap.getInt("conclusionType");
        if (conclusionType == 2) {
            throw new TipException(ResponseCode.IMAGE_GARBAGE_INFO);
        }
        System.out.println(JSON.toJSONString((Object)jsonMap, (boolean)true));
    }
}

