/*
 * Decompiled with CFR 0.152.
 */
package cn.jeeweb.common.quartz.connection;

import com.alibaba.druid.pool.DruidDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.quartz.SchedulerException;
import org.quartz.utils.ConnectionProvider;
import org.quartz.utils.PropertiesParser;

public class DruidConnectionProvider
implements ConnectionProvider {
    public static final String DB_DRIVER = "driver";
    public static final String DB_URL = "URL";
    public static final String DB_USER = "user";
    public static final String DB_PASSWORD = "password";
    public static final String DB_MAX_CONNECTIONS = "maxConnections";
    public static final String DB_MAX_CACHED_STATEMENTS_PER_CONNECTION = "maxCachedStatementsPerConnection";
    public static final String DB_VALIDATION_QUERY = "validationQuery";
    public static final String DB_IDLE_VALIDATION_SECONDS = "idleConnectionValidationSeconds";
    public static final String DB_VALIDATE_ON_CHECKOUT = "validateOnCheckout";
    private static final String DB_DISCARD_IDLE_CONNECTIONS_SECONDS = "discardIdleConnectionsSeconds";
    public static final int DEFAULT_DB_MAX_CONNECTIONS = 10;
    public static final int DEFAULT_DB_MAX_CACHED_STATEMENTS_PER_CONNECTION = 120;
    public String driver;
    public String URL;
    public String user;
    public String password;
    public int maxConnections;
    public String validationQuery;
    private boolean validateOnCheckout;
    private int idleConnectionValidationSeconds;
    public String maxCachedStatementsPerConnection;
    private String discardIdleConnectionsSeconds;
    private DruidDataSource datasource;

    public DruidConnectionProvider() {
    }

    public DruidConnectionProvider(String dbDriver, String dbURL, String dbUser, String dbPassword, int maxConnections, String dbValidationQuery) throws SQLException, SchedulerException {
        this.initialize(dbDriver, dbURL, dbUser, dbPassword, maxConnections, 120, dbValidationQuery, false, 50, 0);
    }

    public DruidConnectionProvider(Properties config) throws SchedulerException, SQLException {
        PropertiesParser cfg = new PropertiesParser(config);
        this.initialize(cfg.getStringProperty(DB_DRIVER), cfg.getStringProperty(DB_URL), cfg.getStringProperty(DB_USER, ""), cfg.getStringProperty(DB_PASSWORD, ""), cfg.getIntProperty(DB_MAX_CONNECTIONS, 10), cfg.getIntProperty(DB_MAX_CACHED_STATEMENTS_PER_CONNECTION, 120), cfg.getStringProperty(DB_VALIDATION_QUERY), cfg.getBooleanProperty(DB_VALIDATE_ON_CHECKOUT, false), cfg.getIntProperty(DB_IDLE_VALIDATION_SECONDS, 50), cfg.getIntProperty(DB_DISCARD_IDLE_CONNECTIONS_SECONDS, 0));
    }

    private void initialize(String dbDriver, String dbURL, String dbUser, String dbPassword, int maxConnections, int maxStatementsPerConnection, String dbValidationQuery, boolean validateOnCheckout, int idleValidationSeconds, int maxIdleSeconds) throws SQLException, SchedulerException {
        if (dbURL == null) {
            throw new SQLException("DBPool could not be created: DB URL cannot be null");
        }
        if (dbDriver == null) {
            throw new SQLException("DBPool '" + dbURL + "' could not be created: " + "DB driver class name cannot be null!");
        }
        if (maxConnections < 0) {
            throw new SQLException("DBPool '" + dbURL + "' could not be created: " + "Max connections must be greater than zero!");
        }
        this.datasource = new DruidDataSource();
        try {
            this.datasource.setDriverClassName(dbDriver);
        }
        catch (Exception e) {
            try {
                throw new SchedulerException("Problem setting driver class name on datasource: " + e.getMessage(), (Throwable)e);
            }
            catch (SchedulerException e1) {
                // empty catch block
            }
        }
        this.datasource.setUrl(dbURL);
        this.datasource.setUsername(dbUser);
        this.datasource.setPassword(dbPassword);
        this.datasource.setMaxActive(maxConnections);
        this.datasource.setMinIdle(1);
        this.datasource.setMaxWait(0L);
        this.datasource.setMaxPoolPreparedStatementPerConnectionSize(10);
        if (dbValidationQuery != null) {
            this.datasource.setValidationQuery(dbValidationQuery);
            if (!validateOnCheckout) {
                this.datasource.setTestOnReturn(true);
            } else {
                this.datasource.setTestOnBorrow(true);
            }
            this.datasource.setValidationQueryTimeout(idleValidationSeconds);
        }
    }

    protected DruidDataSource getDataSource() {
        return this.datasource;
    }

    public Connection getConnection() throws SQLException {
        return this.datasource.getConnection();
    }

    public void shutdown() throws SQLException {
        this.datasource.close();
    }

    public void initialize() throws SQLException {
        try {
            this.initialize(this.driver, this.URL, this.user, this.password, this.maxConnections, 120, this.validationQuery, false, 50, 0);
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getURL() {
        return this.URL;
    }

    public void setURL(String URL2) {
        this.URL = URL2;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public boolean isValidateOnCheckout() {
        return this.validateOnCheckout;
    }

    public void setValidateOnCheckout(boolean validateOnCheckout) {
        this.validateOnCheckout = validateOnCheckout;
    }

    public int getIdleConnectionValidationSeconds() {
        return this.idleConnectionValidationSeconds;
    }

    public void setIdleConnectionValidationSeconds(int idleConnectionValidationSeconds) {
        this.idleConnectionValidationSeconds = idleConnectionValidationSeconds;
    }

    public String getMaxCachedStatementsPerConnection() {
        return this.maxCachedStatementsPerConnection;
    }

    public void setMaxCachedStatementsPerConnection(String maxCachedStatementsPerConnection) {
        this.maxCachedStatementsPerConnection = maxCachedStatementsPerConnection;
    }

    public String getDiscardIdleConnectionsSeconds() {
        return this.discardIdleConnectionsSeconds;
    }

    public void setDiscardIdleConnectionsSeconds(String discardIdleConnectionsSeconds) {
        this.discardIdleConnectionsSeconds = discardIdleConnectionsSeconds;
    }

    public DruidDataSource getDatasource() {
        return this.datasource;
    }

    public void setDatasource(DruidDataSource datasource) {
        this.datasource = datasource;
    }
}

