#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.security.common.runner;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

import java.net.InetAddress;

/**
 * @author jinghong 2019/10/17 08:48
 */
@Slf4j
@Component
public class CustomApplicationRunner implements ApplicationRunner {

    @Value("${symbol_dollar}{server.port:8080}")
    private String serverPort;

    @Override
    public void run(ApplicationArguments args) throws Exception {
        log.info("${symbol_escape}n----------------------------------------------------------${symbol_escape}n" +
                        "Application is running! Access URLs:${symbol_escape}n" +
                        "Local: ${symbol_escape}t${symbol_escape}thttp://localhost:{}/index.html${symbol_escape}n" +
                        "External: ${symbol_escape}thttp://{}:{}/index.html${symbol_escape}n" +
                        "Doc: ${symbol_escape}t${symbol_escape}thttp://localhost:{}/swagger-ui.html${symbol_escape}n" +
                        "----------------------------------------------------------",
                serverPort,
                InetAddress.getLocalHost().getHostAddress(),
                serverPort,
                serverPort);
    }
}