#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.security.modules.quartz.config;

import ${package}.security.modules.quartz.constant.enums.QuartzEnum;
import ${package}.security.modules.quartz.entity.SysJob;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @author <p>
 * 动态任务工厂
 */
@Slf4j
@DisallowConcurrentExecution
public class QuartzFactory implements Job {

    @Autowired
    private QuartzInvokeFactory quartzInvokeFactory;


    @Override
    @SneakyThrows
    public void execute(JobExecutionContext jobExecutionContext) {
        SysJob sysJob = (SysJob) jobExecutionContext.getMergedJobDataMap().get(QuartzEnum.SCHEDULE_JOB_KEY.getType());
        quartzInvokeFactory.init(sysJob, jobExecutionContext.getTrigger());
    }
}
