/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common;

import cn.jiangzeyin.system.SystemBean;
import cn.jiangzeyin.system.log.SystemLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;

public class FileResourceLoader
extends ResourceLoader {
    private static final Map<String, Long> fileLastModified = new HashMap<String, Long>();

    public void init(ExtendedProperties configuration) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResourceStream(String source) throws ResourceNotFoundException {
        File file = null;
        try {
            file = this.getResourceFile(source);
            FileInputStream fileInputStream = new FileInputStream(file);
            return fileInputStream;
        }
        catch (FileNotFoundException e) {
            SystemLog.LOG().info("FileNotFoundException:" + source + "  " + file.getPath());
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(source);
            return inputStream;
        }
        finally {
            if (file != null) {
                fileLastModified.put(source, file.lastModified());
            }
        }
    }

    public boolean isSourceModified(Resource resource) {
        File file;
        long lastModified = resource.getLastModified();
        return lastModified != (file = this.getResourceFile(resource.getName())).lastModified();
    }

    public long getLastModified(Resource resource) {
        return fileLastModified.get(resource.getName());
    }

    private File getResourceFile(String name) {
        return new File(String.format("%s/%s", SystemBean.getInstance().VelocityPath, name));
    }
}

