/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.interceptor;

import cn.jiangzeyin.common.interceptor.InterceptorPattens;
import cn.jiangzeyin.system.log.SystemLog;
import cn.jiangzeyin.util.util.PackageUtil;
import cn.jiangzeyin.util.util.ReflectUtil;
import cn.jiangzeyin.util.util.StringUtil;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration
@EnableWebMvc
public class InterceptorControl
extends WebMvcConfigurerAdapter {
    @Value(value="${interceptor.package:}")
    private String loadPath;

    public void addInterceptors(InterceptorRegistry registry) {
        this.init(registry);
    }

    private void init(InterceptorRegistry registry) {
        List<String> list;
        if (StringUtil.isEmpty(this.loadPath)) {
            return;
        }
        try {
            list = PackageUtil.getClassName(this.loadPath);
        }
        catch (IOException e) {
            SystemLog.ERROR().error("\u52a0\u8f7d\u62e6\u622a\u5668\u5f02\u5e38", (Throwable)e);
            return;
        }
        if (list == null) {
            return;
        }
        for (String item : list) {
            HandlerInterceptor handlerInterceptor;
            boolean isAbstract;
            Class<?> classItem = null;
            try {
                classItem = Class.forName(item);
            }
            catch (ClassNotFoundException e) {
                SystemLog.ERROR().error("\u52a0\u8f7d\u62e6\u622a\u5668\u9519\u8bef", (Throwable)e);
            }
            if (classItem == null || (isAbstract = Modifier.isAbstract(classItem.getModifiers())) || !ReflectUtil.isSuperclass(classItem, HandlerInterceptorAdapter.class)) continue;
            try {
                handlerInterceptor = (HandlerInterceptor)classItem.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                SystemLog.ERROR().error("\u52a0\u8f7d\u62e6\u622a\u5668\u9519\u8bef", (Throwable)e);
                continue;
            }
            InterceptorPattens interceptorPattens = classItem.getAnnotation(InterceptorPattens.class);
            if (interceptorPattens == null) continue;
            String[] patterns = interceptorPattens.value();
            registry.addInterceptor(handlerInterceptor).addPathPatterns(patterns);
            SystemLog.LOG().info("\u52a0\u8f7d\u62e6\u622a\u5668\uff1a" + classItem + "  " + patterns[0]);
        }
    }
}

