/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.request;

import cn.jiangzeyin.common.request.ParameterXssWrapper;
import cn.jiangzeyin.system.SystemBean;
import cn.jiangzeyin.system.log.LogType;
import cn.jiangzeyin.system.log.SystemLog;
import cn.jiangzeyin.util.net.http.RequestUtil;
import cn.jiangzeyin.util.util.StringUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.springframework.web.filter.CharacterEncodingFilter;

public class XssFilter
extends CharacterEncodingFilter {
    private static final ThreadLocal<Long> REQUEST_TIME = new ThreadLocal();
    private static final ThreadLocal<StringBuffer> REQUEST_INFO = new ThreadLocal();

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        REQUEST_TIME.set(System.currentTimeMillis());
        boolean isFile = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (!isFile) {
            request = new ParameterXssWrapper((HttpServletRequest)request);
        }
        this.requestLog((HttpServletRequest)request, isFile);
        super.doFilterInternal(request, response, filterChain);
        this.responseLog(response);
    }

    private void requestLog(HttpServletRequest request, boolean isFile) {
        Map<String, String> header = RequestUtil.getHeaderMapValues(request);
        Map parameters = request.getParameterMap();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(request.getRequestURI());
        stringBuffer.append(" parameters:");
        if (parameters != null) {
            Set entries = parameters.entrySet();
            stringBuffer.append("{");
            for (Map.Entry entry : entries) {
                String key = (String)entry.getKey();
                stringBuffer.append(key).append(":");
                String[] value = (String[])entry.getValue();
                if (value != null) {
                    for (int i = 0; i < value.length; ++i) {
                        if (i != 0) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(isFile ? StringUtil.getUTF8(value[i]) : value[i]);
                    }
                }
                stringBuffer.append(";");
            }
            stringBuffer.append("}");
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(",header:").append(header);
        SystemLog.LOG(LogType.REQUEST).info(stringBuffer.toString());
        REQUEST_INFO.set(stringBuffer);
    }

    private void responseLog(HttpServletResponse response) {
        int status = response.getStatus();
        if (status != 200) {
            String stringBuffer = "status:" + status + ",url:" + REQUEST_INFO.get();
            SystemLog.LOG(LogType.REQUEST_ERROR).error(stringBuffer);
            return;
        }
        Long time = System.currentTimeMillis() - REQUEST_TIME.get();
        if (time > SystemBean.getInstance().request_timeout_log) {
            String stringBuffer = "time:" + time + ",url:" + REQUEST_INFO.get();
            SystemLog.LOG(LogType.REQUEST_ERROR).error(stringBuffer);
        }
    }
}

