/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.spring;

import cn.jiangzeyin.common.spring.SystemInitPackageControl;
import cn.jiangzeyin.system.SystemBean;
import cn.jiangzeyin.system.log.LogType;
import cn.jiangzeyin.system.log.SystemLog;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.audit.listener.AuditApplicationEvent;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextStartedEvent;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.util.Assert;
import org.springframework.web.context.support.ServletRequestHandledEvent;

@Configuration
public class SpringUtil
implements ApplicationListener,
ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringUtil.applicationContext = applicationContext;
        SystemLog.init();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationReadyEvent) {
            SystemInitPackageControl.init();
            SystemLog.LOG().info(SystemBean.getInstance().getSystemTag() + " \u542f\u52a8\u5b8c\u6210");
            return;
        }
        if (event instanceof ContextStartedEvent) {
            System.out.println("3");
        } else if (event instanceof ContextStoppedEvent) {
            System.out.println("stop");
        } else if (event instanceof ContextClosedEvent) {
            SystemLog.LOG().info("\u5173\u95ed\u7a0b\u5e8f");
        } else if (event instanceof ServletRequestHandledEvent) {
            ServletRequestHandledEvent servletRequestHandledEvent = (ServletRequestHandledEvent)event;
            if (!servletRequestHandledEvent.wasFailure()) {
                SystemLog.LOG(LogType.REQUEST).info(servletRequestHandledEvent.toString());
            } else {
                SystemLog.LOG(LogType.REQUEST).info("error:" + servletRequestHandledEvent.toString());
            }
        } else if (event instanceof AuditApplicationEvent) {
            AuditApplicationEvent auditApplicationEvent = (AuditApplicationEvent)event;
            SystemLog.LOG(LogType.REQUEST).info(auditApplicationEvent.toString());
        } else if (!(event instanceof EmbeddedServletContainerInitializedEvent)) {
            System.out.println("else");
            System.out.println(event);
        }
    }

    public static ApplicationContext getApplicationContext() {
        Assert.notNull((Object)applicationContext, (String)"application is null");
        return applicationContext;
    }

    public static Object getBean(String name) {
        return SpringUtil.getApplicationContext().getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)SpringUtil.getApplicationContext().getBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)SpringUtil.getApplicationContext().getBean(name, clazz);
    }
}

