/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.spring;

import cn.jiangzeyin.common.spring.SpringUtil;
import cn.jiangzeyin.system.log.SystemLog;
import cn.jiangzeyin.util.util.PackageUtil;
import cn.jiangzeyin.util.util.StringUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;

class SystemInitPackageControl {
    @Value(value="${initPackageName:}")
    private String initPackageName;
    @Value(value="${initPackageName.methodName:init}")
    private String methodName;
    private static SystemInitPackageControl systemInitPackageControl;

    SystemInitPackageControl() {
    }

    static void init() {
        if (systemInitPackageControl == null) {
            systemInitPackageControl = SpringUtil.getBean(SystemInitPackageControl.class);
        }
        if (StringUtil.isEmpty(SystemInitPackageControl.systemInitPackageControl.initPackageName)) {
            return;
        }
        try {
            List<String> list = PackageUtil.getClassName(SystemInitPackageControl.systemInitPackageControl.initPackageName);
            if (list == null) {
                return;
            }
            for (String name : list) {
                try {
                    Class<?> cls;
                    if (name.contains("$") || (cls = Class.forName(name)) == SystemInitPackageControl.class) continue;
                    Method method = cls.getMethod(SystemInitPackageControl.systemInitPackageControl.methodName, new Class[0]);
                    method.invoke(null, new Object[0]);
                }
                catch (ClassNotFoundException e) {
                    SystemLog.ERROR().error("\u9884\u52a0\u8f7d\u5305\u9519\u8bef:" + name, (Throwable)e);
                }
                catch (Exception e) {
                    SystemLog.ERROR().error("\u9884\u52a0\u8f7d\u5305\u9519\u8bef:" + name + "  \u6267\u884c\u9519\u8bef", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            SystemLog.ERROR().error("\u9884\u52a0\u8f7d\u5305\u9519\u8bef", (Throwable)e);
        }
    }
}

