/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.controller.base;

import cn.jiangzeyin.common.request.ParameterXssWrapper;
import cn.jiangzeyin.controller.base.AbstractBaseControl;
import cn.jiangzeyin.util.ref.ReflectUtil;
import cn.jiangzeyin.util.util.StringUtil;
import cn.jiangzeyin.util.util.file.FileStreamUtil;
import cn.jiangzeyin.util.util.file.FileType;
import cn.jiangzeyin.util.util.file.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public abstract class AbstractMultipartFileBaseControl
extends AbstractBaseControl {
    private Map<String, String[]> parameter;
    private MultipartHttpServletRequest multiRequest;

    @Override
    public void setReqAndRes(HttpServletRequest request, HttpSession session, HttpServletResponse response) {
        super.setReqAndRes(request, session, response);
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            this.multiRequest = (MultipartHttpServletRequest)request;
            this.parameter = ParameterXssWrapper.doXss(this.multiRequest.getParameterMap(), false);
        }
    }

    @Override
    public HttpServletRequest getRequest() {
        if (this.multiRequest == null) {
            return super.getRequest();
        }
        return this.multiRequest;
    }

    protected MultipartFile getFile(String name) {
        Assert.notNull((Object)this.multiRequest);
        return this.multiRequest.getFile(name);
    }

    protected List<MultipartFile> getFiles(String name) {
        Assert.notNull((Object)this.multiRequest);
        return this.multiRequest.getFiles(name);
    }

    protected static boolean checkExt(FileType[] fileTypes, String name, InputStream inputStream) throws IOException {
        Assert.notNull((Object)inputStream);
        if (fileTypes == null) {
            return true;
        }
        FileType fileType = FileStreamUtil.getFileType(inputStream);
        String fileExt = FileUtil.getFileExt(name);
        for (FileType item : fileTypes) {
            if (fileType != item || !item.getExt().equalsIgnoreCase(fileExt)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T getObject(Class<T> tClass) throws IllegalAccessException, InstantiationException {
        if (this.parameter == null) {
            return super.getObject(tClass);
        }
        T object = tClass.newInstance();
        this.doParameterMap(this.parameter, object);
        return object;
    }

    protected <T> T getUpload(Class<T> cls, String path, String ... name) throws IllegalAccessException, InstantiationException, IOException {
        Assert.notNull(this.parameter);
        Assert.notNull((Object)this.multiRequest);
        if (name == null || name.length <= 0) {
            return null;
        }
        path = StringUtil.convertNULL(path);
        T object = cls.newInstance();
        Object localPath = null;
        for (String aName : name) {
            String fileName;
            MultipartFile multiFile = this.getFile(aName);
            if (multiFile == null || StringUtil.isEmpty(fileName = multiFile.getOriginalFilename())) continue;
            String filePath = FileUtil.clearPath(String.format("%s/%s/%s_%s", localPath, path, System.currentTimeMillis(), fileName));
            FileUtil.writeInputStream(multiFile.getInputStream(), new File(filePath));
            ReflectUtil.setFieldValue(object, (String)aName, (Object)filePath);
        }
        this.doParameterMap(this.parameter, object);
        return object;
    }

    @Override
    public String[] getParameters(String name) {
        if (this.parameter == null) {
            return super.getParameters(name);
        }
        return this.parameter.get(name);
    }

    @Override
    protected String getParameter(String name) {
        String[] values = this.getParameters(name);
        return values == null ? null : values[0];
    }

    @Override
    protected String getParameter(String name, String def) {
        String value = this.getParameter(name);
        return value == null ? def : value;
    }

    @Override
    protected int getParameterInt(String name) {
        return this.getParameterInt(name, 0);
    }

    @Override
    protected int getParameterInt(String name, int def) {
        String value = this.getParameter(name);
        return StringUtil.parseInt(value, def);
    }
}

