/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.system;

import cn.jiangzeyin.common.spring.SpringUtil;
import cn.jiangzeyin.util.system.interfaces.UtilSystemValueInterface;
import cn.jiangzeyin.util.system.util.UtilSystemCache;
import cn.jiangzeyin.util.util.StringUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class SystemBean
implements UtilSystemValueInterface,
EnvironmentAware {
    private static volatile SystemBean systemBean;
    public static String SYSTEM_TAG;
    public static String beforeDefaultKey;
    private Active active;
    private Environment environment;
    @Value(value="${spring.velocity.resource-loader-path:}")
    public String VelocityPath;
    @Value(value="${spring.velocity.suffix:}")
    public String velocitySuffix;
    @Value(value="${server.defaultKey}")
    public String defaultKey;
    @Value(value="${request_timeout_log:3000}")
    public Long request_timeout_log;
    @Value(value="${server.tomcat.basedir:}")
    private String tomcatBaseDir;
    @Value(value="${server.domain:}")
    public String domain;
    @Value(value="${spring.profiles.active:dev}")
    private String profiles_active;
    @Value(value="${server.api.token:}")
    public String systemApiToken;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SystemBean getInstance() {
        if (systemBean != null) return systemBean;
        Class<SystemBean> clazz = SystemBean.class;
        synchronized (SystemBean.class) {
            if (systemBean != null) return systemBean;
            systemBean = SpringUtil.getBean(SystemBean.class);
            UtilSystemCache.init(systemBean);
            // ** MonitorExit[var0] (shouldn't be in output)
            return systemBean;
        }
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public String getSystemTag() {
        return SYSTEM_TAG;
    }

    public String getTomcatBaseDir() {
        return this.tomcatBaseDir;
    }

    public Active getActive() {
        if (this.active == null) {
            this.active = Active.valueOf(this.profiles_active);
        }
        if (this.active == Active.prod && StringUtil.isEmpty(this.domain)) {
            throw new RuntimeException("\u751f\u4ea7\u6a21\u5f0f\u8bf7\u914d\u7f6edomain");
        }
        return this.active;
    }

    public boolean isDebug() {
        return this.active == Active.dev;
    }

    static {
        SYSTEM_TAG = "";
    }

    public static enum Active {
        dev("\u5f00\u53d1\u6a21\u5f0f"),
        prod("\u751f\u4ea7\u73af\u5883");

        private String tip;

        public String getTip() {
            return this.tip;
        }

        private Active(String tip) {
            this.tip = tip;
        }
    }
}

