/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.system.log;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedRollingPolicy;
import ch.qos.logback.core.util.FileSize;
import cn.jiangzeyin.system.SystemBean;
import cn.jiangzeyin.system.log.LogType;
import cn.jiangzeyin.util.system.interfaces.UtilSystemLogInterface;
import cn.jiangzeyin.util.system.util.UtilSystemCache;
import cn.jiangzeyin.util.util.StringUtil;
import cn.jiangzeyin.util.util.XmlUtil;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class SystemLog
implements UtilSystemLogInterface {
    private static final LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
    private static final Map<LogType, Logger> LOG_TYPE_LOGGER_MAP = new ConcurrentHashMap<LogType, Logger>();
    private static final Map<String, Logger> LOGGER_MAP = new ConcurrentHashMap<String, Logger>();
    private static final SystemLog systemLog = new SystemLog();
    private static final String TYPE_ERROR_TAG = "ERROR";
    private static final String MY_LOG_TYPENAME = "LogType";
    private static final String LOG_PATH_NAME = "LogPath";
    private static ConsoleAppender consoleAppender;
    private static String LogPath;

    public static void init() {
        consoleAppender = SystemLog.initConsole();
        SystemLog.initLogBackXml();
        SystemLog.initSystemLog();
        UtilSystemCache.init(systemLog);
    }

    private static void initSystemLog() {
        for (LogType type : LogType.values()) {
            String tag = type.toString();
            Level level = Level.INFO;
            if (tag.endsWith(TYPE_ERROR_TAG)) {
                level = Level.ERROR;
            }
            Logger logger = SystemLog.initLogger(tag, tag, level);
            LOG_TYPE_LOGGER_MAP.put(type, logger);
        }
    }

    private static void initLogBackXml() {
        InputStream inputStream = SystemLog.class.getResourceAsStream("/logback-spring.xml");
        try {
            Document document = XmlUtil.load(inputStream);
            Element rootElement = document.getRootElement();
            List property_s = rootElement.elements("property");
            for (Element property : property_s) {
                Attribute name = property.attribute("name");
                String name_value = name.getValue();
                if (MY_LOG_TYPENAME.equalsIgnoreCase(name_value)) {
                    String value = property.attribute("value").getValue();
                    String[] values = StringUtil.StringToArray(value);
                    if (values == null) continue;
                    for (String item : values) {
                        Level level = Level.INFO;
                        if (item.endsWith(TYPE_ERROR_TAG)) {
                            level = Level.ERROR;
                        }
                        Logger logger = SystemLog.initLogger(item, item, level);
                        LOGGER_MAP.put(item, logger);
                    }
                    continue;
                }
                if (!LOG_PATH_NAME.equalsIgnoreCase(name_value)) continue;
                LogPath = property.attribute("value").getValue();
            }
        }
        catch (DocumentException e) {
            SystemLog.ERROR().error("\u52a0\u8f7d\u65e5\u5fd7\u6587\u4ef6xml", (Throwable)e);
        }
    }

    private static ConsoleAppender initConsole() {
        ConsoleAppender appender = new ConsoleAppender();
        PatternLayout patternLayout = new PatternLayout();
        patternLayout.setContext((Context)loggerContext);
        patternLayout.setPattern("%date %level [%thread] %logger{10} [%file:%line]- x:\\(%X\\) %msg%n");
        patternLayout.start();
        appender.setLayout((Layout)patternLayout);
        appender.setContext((Context)loggerContext);
        appender.start();
        return appender;
    }

    private static Logger initLogger(String tag, String path, Level level) {
        Logger logger = (Logger)LoggerFactory.getLogger((String)tag);
        logger.detachAndStopAllAppenders();
        logger.setLevel(level);
        AsyncAppender asyncAppender = new AsyncAppender();
        asyncAppender.setDiscardingThreshold(0);
        asyncAppender.setQueueSize(512);
        RollingFileAppender appender = new RollingFileAppender();
        SizeAndTimeBasedRollingPolicy policy = new SizeAndTimeBasedRollingPolicy();
        policy.setContext((Context)loggerContext);
        policy.setFileNamePattern(String.format("%s/%s/%s/%s-%%d{yyyy-MM-dd}.%%i.log", LogPath, SystemBean.getInstance().getSystemTag(), path, tag));
        policy.setMaxFileSize("100MB");
        policy.setMaxHistory(30);
        policy.setTotalSizeCap(FileSize.valueOf((String)"10GB"));
        policy.setParent((FileAppender)appender);
        policy.start();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)loggerContext);
        encoder.setPattern("%d{HH:mm:ss.SSS} %-5level [%thread %file:%line] %logger - %msg%n");
        encoder.start();
        appender.setFile(String.format("%s/%s/%s/%s.log", LogPath, SystemBean.getInstance().getSystemTag(), path, tag));
        appender.setName("appender" + tag);
        appender.setRollingPolicy((RollingPolicy)policy);
        appender.setContext((Context)loggerContext);
        appender.setEncoder((Encoder)encoder);
        appender.start();
        asyncAppender.addAppender((Appender)appender);
        asyncAppender.start();
        logger.addAppender((Appender)asyncAppender);
        if (level == Level.ERROR) {
            logger.addAppender((Appender)consoleAppender);
        }
        logger.setAdditive(true);
        return logger;
    }

    public static Logger LOG(LogType type) {
        Logger logger = LOG_TYPE_LOGGER_MAP.get((Object)type);
        if (logger == null) {
            return SystemLog.LOG(LogType.DEFAULT);
        }
        return logger;
    }

    public static Logger LOG() {
        return SystemLog.LOG(LogType.DEFAULT);
    }

    public static Logger ERROR() {
        return SystemLog.LOG(LogType.ERROR);
    }

    public static Logger LOG(String type) {
        Logger logger = LOGGER_MAP.get(type);
        if (logger == null) {
            Assert.notNull((Object)type);
            if (type.endsWith(TYPE_ERROR_TAG)) {
                return SystemLog.ERROR();
            }
            return SystemLog.LOG();
        }
        return logger;
    }

    @Override
    public Logger LOG_ERROR() {
        return SystemLog.ERROR();
    }

    @Override
    public Logger LOG_INFO() {
        return SystemLog.LOG();
    }

    static {
        LogPath = "/ztoutiao/log/";
    }
}

