/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.system.pool;

import cn.jiangzeyin.system.log.SystemLog;
import cn.jiangzeyin.system.pool.SystemThreadFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.util.Assert;

public class SystemExecutorService {
    private static final ConcurrentHashMap<Class<?>, ThreadPoolExecutor> ExecutorServiceMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, SystemThreadFactory> THREAD_FACTORY_CONCURRENT_HASH_MAP = new ConcurrentHashMap();

    public static ThreadPoolExecutor newCachedThreadPool(Class<?> class1) {
        Assert.notNull(class1, (String)" \u7ebf\u7a0b\u6c60\u5de5\u4f5c\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        ThreadPoolExecutor executorService = ExecutorServiceMap.get(class1);
        if (executorService == null) {
            executorService = (ThreadPoolExecutor)Executors.newCachedThreadPool();
            ExecutorServiceMap.put(class1, executorService);
            executorService.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
            SystemThreadFactory systemThreadFactory = new SystemThreadFactory(class1.getName());
            THREAD_FACTORY_CONCURRENT_HASH_MAP.put(class1, systemThreadFactory);
            executorService.setThreadFactory(systemThreadFactory);
            SystemLog.LOG().info(class1 + "\u7ebf\u7a0b\u6c60\u7533\u8bf7\u6210\u529f");
        }
        return executorService;
    }

    public static List<ThreadPoolExecutor> getThreadPoolExecutorInfo() {
        ArrayList<ThreadPoolExecutor> executors = new ArrayList<ThreadPoolExecutor>();
        for (Map.Entry<Class<?>, ThreadPoolExecutor> entry : ExecutorServiceMap.entrySet()) {
            executors.add(entry.getValue());
        }
        return executors;
    }

    public static ExecutorService newCachedThreadPool(Object object) {
        Assert.notNull((Object)object, (String)" \u7ebf\u7a0b\u6c60\u5de5\u4f5c\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        return SystemExecutorService.newCachedThreadPool(object.getClass());
    }

    public static void shutdown() {
        for (Map.Entry<Class<?>, ThreadPoolExecutor> entry : ExecutorServiceMap.entrySet()) {
            SystemLog.LOG().info(String.format("\u5173\u95ed%s\u4f7f\u7528\u7684\u7ebf\u7a0b\u6c60", entry.getKey()));
            entry.getValue().shutdown();
        }
    }
}

