/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.util.net.ftp;

import cn.jiangzeyin.util.net.ftp.FtpClientComparator;
import cn.jiangzeyin.util.net.ftp.FtpInfo;
import cn.jiangzeyin.util.net.ftp.FtpUtil;
import cn.jiangzeyin.util.net.ftp.YokeFtp;
import cn.jiangzeyin.util.system.util.UtilSystemCache;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;

public class FTPClientPool {
    private static ConcurrentHashMap<Integer, BlockingQueue<YokeFtp>> poolMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<Integer, Integer> poolNumber = new ConcurrentHashMap();

    public static YokeFtp poll(FtpInfo publishScheme) throws InterruptedException, IOException {
        BlockingQueue<YokeFtp> blockingQueue = FTPClientPool.getQueue(publishScheme);
        YokeFtp ftp = blockingQueue.poll(publishScheme.getTimeOut(), publishScheme.getTimeUnit());
        if (ftp == null || !ftp.isConnected()) {
            FtpUtil.closeConnection(ftp);
            FTPClientPool.addBlockIngQueue(publishScheme);
            return FTPClientPool.poll(publishScheme);
        }
        return ftp;
    }

    public static YokeFtp take(FtpInfo publishScheme) throws InterruptedException, IOException {
        BlockingQueue<YokeFtp> blockingQueue = FTPClientPool.getQueue(publishScheme);
        YokeFtp ftp = blockingQueue.take();
        if (ftp == null || !ftp.isConnected()) {
            FtpUtil.closeConnection(ftp);
            FTPClientPool.addBlockIngQueue(publishScheme);
            return FTPClientPool.take(publishScheme);
        }
        return ftp;
    }

    public static boolean release(YokeFtp ftp) {
        FtpUtil.closeConnection(ftp);
        return true;
    }

    public static boolean release(YokeFtp[] ftps) {
        if (ftps == null) {
            return false;
        }
        for (YokeFtp yokeFtp : ftps) {
            if (FTPClientPool.release(yokeFtp)) continue;
            return false;
        }
        return true;
    }

    private static BlockingQueue<YokeFtp> getQueue(FtpInfo publishScheme) {
        BlockingQueue<YokeFtp> blockingQueue = poolMap.get(publishScheme.getId());
        if (blockingQueue == null) {
            blockingQueue = FTPClientPool.initPublish(publishScheme);
        }
        return blockingQueue;
    }

    private static BlockingQueue<YokeFtp> initPublish(FtpInfo publishScheme) {
        int maxConnects = publishScheme.getMaxConnects();
        PriorityBlockingQueue<YokeFtp> blockingQueue = new PriorityBlockingQueue<YokeFtp>(maxConnects, new FtpClientComparator());
        for (int i = 0; i < maxConnects; ++i) {
            YokeFtp ftpClient;
            try {
                ftpClient = FtpUtil.getFtpClient(publishScheme);
            }
            catch (IOException e) {
                UtilSystemCache.getInstance().LOG_ERROR().error("\u521d\u59cb\u5316ftp\u8fde\u63a5\u5931\u8d25", (Throwable)e);
                continue;
            }
            FTPClientPool.addToQueur(blockingQueue, ftpClient);
        }
        poolMap.put(publishScheme.getId(), blockingQueue);
        return blockingQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToQueur(BlockingQueue<YokeFtp> blockingQueue, YokeFtp ftp) {
        if (ftp == null) {
            return;
        }
        BlockingQueue<YokeFtp> blockingQueue2 = blockingQueue;
        synchronized (blockingQueue2) {
            Integer integer = poolNumber.get(ftp.getSchemeId());
            integer = integer == null ? Integer.valueOf(0) : Integer.valueOf(integer + 1);
            ftp.setOrder(integer);
            poolNumber.put(ftp.getSchemeId(), integer);
            blockingQueue.add(ftp);
        }
    }

    private static void addBlockIngQueue(FtpInfo publishScheme) throws IOException {
        BlockingQueue<YokeFtp> blockingQueue = FTPClientPool.getQueue(publishScheme);
        YokeFtp ftpClient = FtpUtil.getFtpClient(publishScheme);
        if (ftpClient == null) {
            throw new RuntimeException("ftp \u521b\u5efa\u5931\u8d25");
        }
        FTPClientPool.addToQueur(blockingQueue, ftpClient);
    }
}

