/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.util.net.ftp;

import cn.jiangzeyin.util.net.ftp.FtpInfo;
import cn.jiangzeyin.util.net.ftp.YokeFtp;
import cn.jiangzeyin.util.system.util.UtilSystemCache;
import cn.jiangzeyin.util.util.StringUtil;
import cn.jiangzeyin.util.util.file.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.LinkedList;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.springframework.util.Assert;

public class FtpUtil {
    private static final String fileEncodingName = "ISO-8859-1";

    public static FTPClient getFtpClient(String server, int port, String username, String password, String encoding, int mode) throws IOException {
        YokeFtp ftp = new YokeFtp();
        ftp.setDefaultTimeout(40000);
        ftp.setDefaultPort(port);
        ftp.connect(server);
        ftp.setControlEncoding(encoding);
        ftp.login(username, password);
        ftp.setSoTimeout(40000);
        ftp.setConnectTimeout(40000);
        ftp.setFileType(2);
        if (mode == 1) {
            ftp.enterLocalPassiveMode();
        } else {
            ftp.enterLocalActiveMode();
        }
        String FtpRoot = ftp.printWorkingDirectory();
        ftp.changeWorkingDirectory(FtpRoot);
        return ftp;
    }

    public static YokeFtp getFtpClient(FtpInfo ftpInfo) throws IOException {
        YokeFtp ftp = new YokeFtp();
        ftp.setDefaultPort(ftpInfo.getPort());
        ftp.connect(ftpInfo.getIp());
        ftp.setControlEncoding(ftpInfo.getEncoding());
        if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
            return null;
        }
        ftp.login(ftpInfo.getUserName(), ftpInfo.getUserPwd());
        ftp.setSoTimeout(ftpInfo.getTimeOut());
        ftp.setConnectTimeout(ftpInfo.getTimeOut());
        if (ftpInfo.getMode() == 1) {
            ftp.enterLocalPassiveMode();
        } else {
            ftp.enterLocalActiveMode();
        }
        ftp.setSchemeId(ftpInfo.getId());
        ftp.setDataTimeout(ftpInfo.getTimeOut());
        ftp.setKeepAlive(true);
        return ftp;
    }

    public static boolean togetherUploadFolder(YokeFtp ftpClient, String localPath, String remotePath, int tryCount) throws IOException {
        Assert.notNull((Object)((Object)ftpClient));
        LinkedList<File> linkedList = FileUtil.getFolderFiles(localPath);
        Assert.notNull(linkedList, (String)"\u6ca1\u6709\u4efb\u4f55\u6587\u4ef6");
        remotePath = StringUtil.convertNULL(remotePath);
        for (File file : linkedList) {
            if (!file.exists()) {
                UtilSystemCache.getInstance().LOG_INFO().info("\u9519\u8bef\uff01\u6587\u4ef6\u4e0d\u5b58\u5728\uff01" + file.getPath());
                continue;
            }
            String lopath = StringUtil.cleanPath(file.getAbsolutePath());
            String repath = lopath.substring(lopath.indexOf(remotePath));
            String rpath = repath.substring(0, repath.lastIndexOf("/") + 1);
            String rname = repath.substring(repath.lastIndexOf("/") + 1);
            int errorCount = 0;
            boolean isSuccess = false;
            while (errorCount <= tryCount) {
                boolean flag;
                try {
                    flag = FtpUtil.uploadFile(ftpClient, file, rpath, rname);
                }
                catch (SocketTimeoutException e) {
                    UtilSystemCache.getInstance().LOG_ERROR().error("\u8b66\u544a\uff1a" + lopath + "---\u8bfb\u53d6\u8d85\u65f6", (Throwable)e);
                    ++errorCount;
                    continue;
                }
                catch (SocketException e) {
                    UtilSystemCache.getInstance().LOG_ERROR().error("\u9519\u8bef\uff01\u94fe\u63a5\u88ab\u91cd\u7f6e" + ((Object)((Object)ftpClient)).toString(), (Throwable)e);
                    ++errorCount;
                    continue;
                }
                catch (Exception e) {
                    UtilSystemCache.getInstance().LOG_ERROR().error("ftp \u53d1\u5e03\u5931\u8d25", (Throwable)e);
                    return false;
                }
                isSuccess = flag;
                if (isSuccess) break;
                ++errorCount;
            }
            if (isSuccess) continue;
            UtilSystemCache.getInstance().LOG_INFO().info("sendFile:" + lopath + "\u9519\u8bef\u6b21\u6570\u8fc7\u9ad8,\u9000\u51fa\u53d1\u5e03\uff01");
            return false;
        }
        return true;
    }

    public static boolean FtpUpload(YokeFtp ftp, String fileName, String remotePath) throws IOException {
        return FtpUtil.uploadFile(ftp, new File(fileName), remotePath);
    }

    public static boolean FtpUpload(YokeFtp ftp, String fileName, String rootPath, String remotePath) throws IOException {
        File file = new File(fileName);
        String path = FileUtil.getFilePath(file).replace(rootPath, "");
        remotePath = String.format("%s/%s", StringUtil.convertNULL(remotePath), path);
        return FtpUtil.uploadFile(ftp, file, remotePath);
    }

    public static boolean uploadFile(YokeFtp ftp, File file, String remotePath) throws IOException {
        return FtpUtil.uploadFile(ftp, file, remotePath, null);
    }

    public static boolean uploadFile(YokeFtp ftp, File file, String remotePath, String remoteName) throws IOException {
        Assert.notNull((Object)((Object)ftp), (String)"ftp \u4fe1\u606f\u4e0d\u80fd\u4e3akong");
        Assert.notNull((Object)file, (String)"\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        if (!file.exists() || file.isDirectory()) {
            throw new IllegalArgumentException("ftp \u4e0a\u4f20\u5f53\u4e2a\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u8005\u4e3a\u4e00\u4e2a\u6587\u4ef6\u5939");
        }
        boolean flag = FtpUtil.changeWorkingDirectory(ftp, remotePath);
        if (!flag) {
            UtilSystemCache.getInstance().LOG_INFO().info(String.format("ftp\u5207\u6362\u76ee\u5f55\u5931\u8d25,\u6587\u4ef6:%s", remotePath));
            return false;
        }
        ftp.setBufferSize(4096);
        ftp.setControlKeepAliveTimeout(500L);
        ftp.setFileType(2);
        ftp.enterLocalPassiveMode();
        FileInputStream is = new FileInputStream(file);
        String OnlyFileName = StringUtil.isEmpty(remoteName) ? new String(file.getName().getBytes(), fileEncodingName) : new String(remoteName.getBytes(), fileEncodingName);
        boolean storeFile = ftp.storeFile(OnlyFileName, is);
        if (!storeFile) {
            UtilSystemCache.getInstance().LOG_INFO().info(String.format("ftp\u4e0a\u4f20\u5931\u8d25,\u6587\u4ef6:%s", storeFile));
        }
        ((InputStream)is).close();
        return storeFile;
    }

    public static boolean uploadFolder(YokeFtp ftp, String rootPath) throws IOException {
        File file = new File(rootPath);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(rootPath + " \u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6\u5939");
        }
        return FtpUtil.FtpUpload(ftp, rootPath, false);
    }

    public static boolean FtpUpload(YokeFtp ftp, String rootPath, String remotePath, boolean containName) throws IOException {
        File file = new File(rootPath);
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            return FtpUtil.UploadDirectoryPath(ftp, rootPath, file.getPath(), remotePath, containName);
        }
        return FtpUtil.FtpUploadFile(ftp, file, rootPath, remotePath, containName);
    }

    private static boolean UploadDirectoryPath(YokeFtp ftp, String rootPath, String currPath, String remotePath, boolean containName) throws IOException {
        File file = new File(currPath);
        if (!file.exists()) {
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return false;
        }
        for (File item : files) {
            boolean flag;
            if (!(item.isDirectory() ? !FtpUtil.UploadDirectoryPath(ftp, rootPath, item.getPath(), remotePath, containName) : !(flag = FtpUtil.FtpUploadFile(ftp, item, rootPath, remotePath, containName)))) continue;
            return false;
        }
        return true;
    }

    public static boolean FtpUpload(YokeFtp ftp, String rootPath, boolean containName) throws IOException {
        return FtpUtil.FtpUpload(ftp, rootPath, "/", containName);
    }

    private static boolean FtpUploadFile(YokeFtp ftp, File file, String rootPath, String remotePath, boolean containName) throws IOException {
        Assert.notNull((Object)file, (String)"\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtil.isEmpty(remotePath)) {
            remotePath = "/";
        }
        String newRemotePath = FileUtil.getFilePath(file).replace(rootPath, "");
        newRemotePath = String.format("%s/%s", remotePath, newRemotePath);
        if (containName) {
            String name = new File(rootPath).getName();
            newRemotePath = String.format("%s/%s", name, newRemotePath);
        }
        return FtpUtil.uploadFile(ftp, file, newRemotePath);
    }

    private static boolean changeWorkingDirectory(FTPClient ftpClient, String remotePath) throws IOException {
        String directory = FileUtil.clearPath(remotePath);
        if (directory.equals("/")) {
            ftpClient.changeWorkingDirectory("/");
            return true;
        }
        if (directory.startsWith("/")) {
            ftpClient.changeWorkingDirectory("/");
        }
        if (!ftpClient.changeWorkingDirectory(new String(directory.getBytes(), fileEncodingName))) {
            String[] paths;
            for (String string : paths = StringUtil.StringToArray(directory, "/")) {
                String subDirectory = new String(string.getBytes(), fileEncodingName);
                if (ftpClient.changeWorkingDirectory(subDirectory)) continue;
                if (ftpClient.makeDirectory(subDirectory)) {
                    if (ftpClient.changeWorkingDirectory(subDirectory)) continue;
                    return false;
                }
                UtilSystemCache.getInstance().LOG_ERROR().error("ftp \u76ee\u5f55\u521b\u5efa\u5931\u8d25", (Throwable)new RuntimeException(subDirectory));
                return false;
            }
        }
        return true;
    }

    public static boolean removeDirectoryALLFile(FTPClient ftp, String pathName) throws IOException {
        FTPFile[] files = ftp.listFiles(pathName);
        if (null != files && files.length > 0) {
            for (FTPFile file : files) {
                if (file.isDirectory()) {
                    FtpUtil.removeDirectoryALLFile(ftp, pathName + "/" + file.getName());
                    ftp.changeWorkingDirectory(pathName.substring(0, pathName.lastIndexOf("/")));
                    ftp.removeDirectory(pathName);
                    continue;
                }
                if (ftp.deleteFile(pathName + "/" + file.getName())) continue;
                return false;
            }
        }
        ftp.changeWorkingDirectory(pathName.substring(0, pathName.lastIndexOf("/")));
        ftp.removeDirectory(pathName);
        return true;
    }

    public static boolean deleteFile(FTPClient ftp, String path) throws IOException {
        return ftp.deleteFile(path);
    }

    public static void closeConnection(YokeFtp ftpClient) {
        if (ftpClient == null) {
            return;
        }
        try {
            ftpClient.logout();
            ftpClient.disconnect();
        }
        catch (IOException e) {
            UtilSystemCache.getInstance().LOG_ERROR().error("\u5173\u95edftp \u8fde\u63a5\u9519\u8bef", (Throwable)e);
        }
    }

    public static void closeConnection(YokeFtp[] ftpClients) {
        if (ftpClients == null) {
            return;
        }
        for (YokeFtp ftpClient2 : ftpClients) {
            FtpUtil.closeConnection(ftpClient2);
        }
    }
}

