/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.util.net.http;

import cn.jiangzeyin.util.util.StringUtil;
import cn.jiangzeyin.util.util.file.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;

public class HttpClientUtils {
    private static RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(15000).setConnectTimeout(15000).setConnectionRequestTimeout(15000).build();

    public static String sendHttpPost(String url, Map<String, String> paramMap) throws Exception {
        CloseableHttpClient httpclient = HttpClientUtils.getHttpClient();
        return HttpClientUtils.sendHttpPost(url, paramMap, httpclient);
    }

    public static String sendHttpPost(String url, String params) throws Exception {
        CloseableHttpClient httpclient = HttpClientUtils.getHttpClient();
        return HttpClientUtils.sendHttpPost(url, params, httpclient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttpPost(String url, File file) throws Exception {
        try (CloseableHttpClient httpclient = HttpClientUtils.getHttpClient();){
            HttpPost httpPost = new HttpPost(url);
            InputStreamEntity reqEntity = new InputStreamEntity((InputStream)new FileInputStream(file), -1L, ContentType.APPLICATION_OCTET_STREAM);
            reqEntity.setChunked(true);
            httpPost.setEntity((HttpEntity)reqEntity);
            String string = HttpClientUtils.sendHttpPost(httpPost, httpclient);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttpPostByStream(String url, String binaryStreamsStr) throws Exception {
        try (CloseableHttpClient httpclient = HttpClientUtils.getHttpClient();){
            HttpPost httpPost = new HttpPost(url);
            ByteArrayEntity reqEntity = new ByteArrayEntity(binaryStreamsStr.getBytes(Consts.UTF_8), ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)reqEntity);
            String string = HttpClientUtils.sendHttpPost(httpPost, httpclient);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttpPostByFile(String url, Map<String, String> paraMap, Map<String, File> fileMap) throws Exception {
        try (CloseableHttpClient httpclient = HttpClientUtils.getHttpClient();){
            HttpPost httpPost = new HttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            for (String key : paraMap.keySet()) {
                builder.addPart(key, (ContentBody)new StringBody(paraMap.get(key), ContentType.TEXT_PLAIN));
            }
            for (String fileStr : fileMap.keySet()) {
                builder.addPart(fileStr, (ContentBody)new FileBody(fileMap.get(fileStr)));
            }
            HttpEntity reqEntity = builder.build();
            httpPost.setEntity(reqEntity);
            String string = HttpClientUtils.sendHttpPost(httpPost, httpclient);
            return string;
        }
    }

    public static String sendHttpGet(String url) throws Exception {
        try (CloseableHttpClient httpclient = HttpClientUtils.getHttpClient();){
            String string = HttpClientUtils.sendHttpGet(url, httpclient);
            return string;
        }
    }

    public static byte[] sendHttpGetResByte(String url) throws Exception {
        try (CloseableHttpClient httpclient = HttpClientUtils.getHttpClient();){
            byte[] byArray = HttpClientUtils.sendHttpGetResByte(url, httpclient);
            return byArray;
        }
    }

    public static String sendHttpGet(String url, String params) throws Exception {
        CloseableHttpClient httpclient = HttpClientUtils.getHttpClient();
        return HttpClientUtils.sendHttpGet(url, params, httpclient);
    }

    public static String sendHttpsGet(String url, String params) throws Exception {
        CloseableHttpClient httpclient = HttpClientUtils.getHttpsClient(url);
        return HttpClientUtils.sendHttpGet(url, params, httpclient);
    }

    public static String sendHttpsGet(String url) throws Exception {
        try (CloseableHttpClient httpclient = HttpClientUtils.getHttpsClient(url);){
            String string = HttpClientUtils.sendHttpGet(url, httpclient);
            return string;
        }
    }

    public static String sendHttpsPost(String url, Map<String, String> paramMap) throws Exception {
        CloseableHttpClient httpclient = HttpClientUtils.getHttpsClient(url);
        return HttpClientUtils.sendHttpPost(url, paramMap, httpclient);
    }

    public static String sendHttpsPost(String url, String params) throws Exception {
        CloseableHttpClient httpclient = HttpClientUtils.getHttpsClient(url);
        return HttpClientUtils.sendHttpPost(url, params, httpclient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendHttpGet(String url, String params, CloseableHttpClient httpclient) throws Exception {
        try {
            String sb = url + "?" + params;
            String string = HttpClientUtils.sendHttpGet(sb, httpclient);
            return string;
        }
        finally {
            httpclient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendHttpPost(String url, Map<String, String> paramMap, CloseableHttpClient httpclient) throws Exception {
        try {
            HttpPost httpPost = new HttpPost(url);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            for (String key : paramMap.keySet()) {
                nvps.add(new BasicNameValuePair(key, paramMap.get(key)));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
            String string = HttpClientUtils.sendHttpPost(httpPost, httpclient);
            return string;
        }
        finally {
            httpclient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendHttpPost(String url, String params, CloseableHttpClient httpclient) throws Exception {
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)new StringEntity(params, Consts.UTF_8));
            String string = HttpClientUtils.sendHttpPost(httpPost, httpclient);
            return string;
        }
        finally {
            httpclient.close();
        }
    }

    private static CloseableHttpClient getHttpClient() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (chain, authType) -> true).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
    }

    private static CloseableHttpClient getHttpsClient(String url) throws Exception {
        PublicSuffixMatcher publicSuffixMatcher = PublicSuffixMatcherLoader.load((URL)new URL(url));
        DefaultHostnameVerifier hostnameVerifier = new DefaultHostnameVerifier(publicSuffixMatcher);
        CloseableHttpClient httpclient = HttpClients.custom().setSSLHostnameVerifier((HostnameVerifier)hostnameVerifier).build();
        return httpclient;
    }

    private static String sendHttpPost(HttpPost httpPost, CloseableHttpClient httpclient) throws Exception {
        httpPost.setConfig(requestConfig);
        try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);){
            HttpEntity entity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
            return string;
        }
    }

    private static String sendHttpGet(String url, CloseableHttpClient httpclient) throws Exception {
        HttpGet httpGet = new HttpGet(url);
        httpGet.setConfig(requestConfig);
        try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);){
            HttpEntity entity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
            return string;
        }
    }

    private static byte[] sendHttpGetResByte(String url, CloseableHttpClient httpclient) throws Exception {
        HttpGet httpGet = new HttpGet(url);
        httpGet.setConfig(requestConfig);
        try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);){
            HttpEntity entity = response.getEntity();
            byte[] byArray = EntityUtils.toByteArray((HttpEntity)entity);
            return byArray;
        }
    }

    public static boolean downloadFile(String url, String target) throws NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        if (!StringUtil.convertNULL(url).startsWith("https://")) {
            return false;
        }
        HttpGet httpGet = new HttpGet(url);
        httpGet.setConfig(requestConfig);
        CloseableHttpClient httpclient = HttpClientUtils.getHttpClient();
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            return false;
        }
        HttpEntity entity = response.getEntity();
        InputStream inputStream = entity.getContent();
        FileUtil.mkdirs(target);
        byte[] bs = new byte[1024];
        FileOutputStream os = new FileOutputStream(target);
        int len = 0;
        while ((len = inputStream.read(bs)) != -1) {
            ((OutputStream)os).write(bs, 0, len);
        }
        ((OutputStream)os).close();
        inputStream.close();
        return true;
    }

    public static String post(String url, List<NameValuePair> pairList) throws Exception {
        if (!StringUtil.convertNULL(url).startsWith("https://")) {
            return null;
        }
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList));
        httpPost.setConfig(requestConfig);
        CloseableHttpClient httpclient = HttpClientUtils.getHttpClient();
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            return null;
        }
        HttpEntity entity = response.getEntity();
        return EntityUtils.toString((HttpEntity)entity);
    }
}

