/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.util.net.http;

import cn.jiangzeyin.util.net.http.HttpClientUtils;
import cn.jiangzeyin.util.util.StringUtil;
import cn.jiangzeyin.util.util.file.FileUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.activation.MimetypesFileTypeMap;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    public static String convertHttpPath(String path) {
        if (StringUtil.isEmpty(path)) {
            return null;
        }
        if (path.startsWith("//")) {
            return String.format("http:%s", path);
        }
        return path;
    }

    public static boolean downloadFile(String fileurl, String target) throws IOException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        if (StringUtil.isEmpty(fileurl)) {
            return false;
        }
        fileurl = HttpUtil.convertHttpPath(fileurl);
        assert (fileurl != null);
        URL url = new URL(fileurl);
        URLConnection urlConnection = url.openConnection();
        int responseCode = 0;
        if (fileurl.startsWith("https://")) {
            return HttpClientUtils.downloadFile(fileurl, target);
        }
        if (!fileurl.startsWith("http://")) {
            return false;
        }
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        responseCode = httpConn.getResponseCode();
        if (responseCode == 302) {
            String redictURL = urlConnection.getHeaderField("Location");
            return HttpUtil.downloadFile(redictURL, target);
        }
        if (responseCode != 200) {
            return false;
        }
        FileUtil.mkdirs(target);
        InputStream is = urlConnection.getInputStream();
        byte[] bs = new byte[1024];
        FileOutputStream os = new FileOutputStream(target);
        int len = 0;
        while ((len = is.read(bs)) != -1) {
            ((OutputStream)os).write(bs, 0, len);
        }
        ((OutputStream)os).close();
        is.close();
        return true;
    }

    public static String doGet(String pageUrl, String encoding) throws Exception {
        String line;
        StringBuilder sb = new StringBuilder();
        URL url = new URL(pageUrl);
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), encoding));
        while ((line = in.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        in.close();
        return sb.toString();
    }

    public static String formUpload(String urlStr, Map<String, String> textMap, Map<String, String> fileMap) throws Exception {
        String res = "";
        HttpURLConnection conn = null;
        String BOUNDARY = "---------------------------" + UUID.randomUUID();
        URL url = new URL(urlStr);
        conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(30000);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.1; zh-CN; rv:1.9.2.6)");
        conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
        DataOutputStream out = new DataOutputStream(conn.getOutputStream());
        if (textMap != null) {
            StringBuilder strBuf = new StringBuilder();
            for (Map.Entry<String, String> entry : textMap.entrySet()) {
                String inputName = entry.getKey();
                String inputValue = entry.getValue();
                if (inputValue == null) continue;
                strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                strBuf.append("Content-Disposition: form-data; name=\"").append(inputName).append("\"\r\n\r\n");
                strBuf.append(inputValue);
            }
            ((OutputStream)out).write(strBuf.toString().getBytes());
        }
        if (fileMap != null) {
            for (Map.Entry entry : fileMap.entrySet()) {
                String inputName = (String)entry.getKey();
                String inputValue = (String)entry.getValue();
                if (inputValue == null) continue;
                File file = new File(inputValue);
                String filename = file.getName();
                String contentType = new MimetypesFileTypeMap().getContentType(file);
                if (contentType == null || contentType.equals("")) {
                    contentType = "application/octet-stream";
                }
                StringBuilder strBuf = new StringBuilder();
                strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                strBuf.append("Content-Disposition: form-data; name=\"").append(inputName).append("\"; filename=\"").append(filename).append("\"\r\n");
                strBuf.append("Content-Type:").append(contentType).append("\r\n\r\n");
                ((OutputStream)out).write(strBuf.toString().getBytes());
                DataInputStream in = new DataInputStream(new FileInputStream(file));
                int bytes = 0;
                byte[] bufferOut = new byte[1024];
                while ((bytes = in.read(bufferOut)) != -1) {
                    ((OutputStream)out).write(bufferOut, 0, bytes);
                }
                in.close();
            }
        }
        byte[] endData = ("\r\n--" + BOUNDARY + "--\r\n").getBytes();
        ((OutputStream)out).write(endData);
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String line = null;
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line).append("\n");
        }
        res = stringBuilder.toString();
        reader.close();
        reader = null;
        conn.disconnect();
        conn = null;
        return res;
    }

    public static String doPost(String url, List<NameValuePair> pair, String charset) throws IOException {
        CloseableHttpClient closeableHttpClient;
        CloseableHttpResponse response;
        int status;
        HttpPost httpRequest = new HttpPost(url);
        if (pair != null && pair.size() > 0) {
            httpRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(pair, charset));
        }
        if ((status = (response = (closeableHttpClient = HttpClientBuilder.create().build()).execute((HttpUriRequest)httpRequest)).getStatusLine().getStatusCode()) == 200) {
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        throw new RuntimeException("http " + status + "  " + EntityUtils.toString((HttpEntity)response.getEntity()));
    }

    public static JSONObject doPostJSONObject(String url, List<NameValuePair> pair, String charset) throws IOException {
        CloseableHttpClient closeableHttpClient;
        CloseableHttpResponse response;
        int status;
        HttpPost httpRequest = new HttpPost(url);
        if (pair != null && pair.size() > 0) {
            httpRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(pair, charset));
        }
        if ((status = (response = (closeableHttpClient = HttpClientBuilder.create().build()).execute((HttpUriRequest)httpRequest)).getStatusLine().getStatusCode()) == 200) {
            return JSON.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        throw new RuntimeException("http " + status + "  " + EntityUtils.toString((HttpEntity)response.getEntity()));
    }

    public static String getHtmlContent(String url_, String encode) throws IOException {
        StringBuilder contentBuffer = new StringBuilder();
        int responseCode = -1;
        HttpURLConnection con = null;
        URL url = new URL(url_);
        con = (HttpURLConnection)url.openConnection();
        con.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        con.setConnectTimeout(60000);
        con.setReadTimeout(60000);
        con.setInstanceFollowRedirects(true);
        responseCode = con.getResponseCode();
        if (responseCode == 302) {
            String l = con.getHeaderField("Location");
            return HttpUtil.getHtmlContent(l, encode);
        }
        if (responseCode == -1) {
            con.disconnect();
            return null;
        }
        if (responseCode >= 400) {
            con.disconnect();
            return null;
        }
        InputStream inStr = con.getInputStream();
        InputStreamReader istreamReader = new InputStreamReader(inStr, encode);
        BufferedReader buffStr = new BufferedReader(istreamReader);
        String str = null;
        while ((str = buffStr.readLine()) != null) {
            contentBuffer.append(str);
        }
        inStr.close();
        con.disconnect();
        return contentBuffer.toString();
    }
}

