/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.util.net.http;

import cn.jiangzeyin.util.net.http.HttpUtil;
import cn.jiangzeyin.util.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class RequestUtil {
    public static String getIpAddress(HttpServletRequest request) {
        String ipFromNginx = request.getHeader("X-Real-IP");
        if (!StringUtil.isEmpty(ipFromNginx)) {
            return ipFromNginx;
        }
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        ip = StringUtil.convertNULL(ip);
        return ip;
    }

    public static String getIpInfo(HttpServletRequest request) {
        StringBuilder ipInfo = new StringBuilder();
        String ipFromNginx = request.getHeader("X-Real-IP");
        if (!StringUtil.isEmpty(ipFromNginx)) {
            ipInfo.append("X-Real-IP:").append(ipFromNginx);
        }
        String ip = request.getHeader("x-forwarded-for");
        ipInfo.append("x-forwarded-for:" + ip);
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
            ipInfo.append("Proxy-Client-IP:" + ip);
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
            ipInfo.append("WL-Proxy-Client-IP:" + ip);
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
            ipInfo.append("HTTP_CLIENT_IP:" + ip);
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
            ipInfo.append("HTTP_X_FORWARDED_FOR:" + ip);
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
            ipInfo.append("Addr:" + ip);
        }
        ipInfo.append(ip);
        return ipInfo.toString();
    }

    public String getBrowserName(String agent) {
        if (agent.indexOf("msie 7") > 0) {
            return "ie7";
        }
        if (agent.indexOf("msie 8") > 0) {
            return "ie8";
        }
        if (agent.indexOf("msie 9") > 0) {
            return "ie9";
        }
        if (agent.indexOf("msie 10") > 0) {
            return "ie10";
        }
        if (agent.indexOf("msie") > 0) {
            return "ie";
        }
        if (agent.indexOf("opera") > 0) {
            return "opera";
        }
        if (agent.indexOf("opera") > 0) {
            return "opera";
        }
        if (agent.indexOf("firefox") > 0) {
            return "firefox";
        }
        if (agent.indexOf("webkit") > 0) {
            return "webkit";
        }
        if (agent.indexOf("gecko") > 0 && agent.indexOf("rv:11") > 0) {
            return "ie11";
        }
        return "Others";
    }

    public static void addCookie(HttpServletResponse response, String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("../");
        if (maxAge > 0) {
            cookie.setMaxAge(maxAge);
        }
        response.addCookie(cookie);
    }

    public static void deleteCookie(HttpServletRequest request, HttpServletResponse response, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                cookie.setValue(null);
                cookie.setMaxAge(0);
                cookie.setPath("/");
                response.addCookie(cookie);
                break;
            }
        }
    }

    public static Cookie getCookieByName(HttpServletRequest request, String name) {
        Map<String, Cookie> cookieMap = RequestUtil.ReadCookieMap(request);
        if (cookieMap.containsKey(name)) {
            Cookie cookie = cookieMap.get(name);
            return cookie;
        }
        return null;
    }

    private static Map<String, Cookie> ReadCookieMap(HttpServletRequest request) {
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie);
            }
        }
        return cookieMap;
    }

    public static Map<String, String> getCookieMapValues(HttpServletRequest request) {
        HashMap<String, String> cookieMap = new HashMap<String, String>();
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie.getValue());
            }
        }
        return cookieMap;
    }

    public static Map<String, String> getHeaderMapValues(HttpServletRequest request) {
        Enumeration enumeration = request.getHeaderNames();
        HashMap<String, String> headerMapValues = new HashMap<String, String>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                headerMapValues.put(name, request.getHeader(name));
            }
        }
        return headerMapValues;
    }

    public static String getIpAddressRegion(String ipAddress) throws Exception {
        String apiData = HttpUtil.doGet("http://ip.taobao.com/service/getIpInfo.php?ip=" + ipAddress, "UTF-8");
        JSONObject jsonObject = JSON.parseObject((String)apiData);
        JSONObject data = jsonObject.getJSONObject("data");
        if (data == null) {
            return "\u672a\u77e5\u5730\u5740";
        }
        return data.getString("country") + data.getString("region") + data.getString("city") + data.getString("county") + "_\u5730\u533a\uff1a" + data.getString("area");
    }

    public static String getIpInfo(String ip) throws Exception {
        String data = HttpUtil.doGet("http://ip.taobao.com/service/getIpInfo.php?ip=" + ip, "UTF-8");
        JSONObject obj = JSON.parseObject((String)data);
        return obj.toJSONString();
    }
}

