/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.util.util;

import cn.jiangzeyin.util.util.StringUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public final class JsonUtil {
    public static JSONArray sortJsonArrayByDate(JSONArray mJSONArray, String dateName) {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        JSONObject jsonObj = null;
        for (int i = 0; i < mJSONArray.size(); ++i) {
            jsonObj = mJSONArray.getJSONObject(i);
            list.add(jsonObj);
        }
        JsonComparator pComparator = new JsonComparator(dateName);
        Collections.sort(list, pComparator);
        JSONArray mJSONArray_ = new JSONArray();
        for (int i = 0; i < list.size(); ++i) {
            jsonObj = (JSONObject)list.get(i);
            mJSONArray_.add((Object)jsonObj);
        }
        return mJSONArray_;
    }

    public static JSONArray sortJsonArrayByDate(JSONArray mJSONArray, String dateName, String way) {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        JSONObject jsonObj = null;
        for (int i = 0; i < mJSONArray.size(); ++i) {
            jsonObj = mJSONArray.getJSONObject(i);
            list.add(jsonObj);
        }
        JsonComparator pComparator = new JsonComparator(dateName, way);
        Collections.sort(list, pComparator);
        JSONArray mJSONArray_ = new JSONArray();
        for (int i = 0; i < list.size(); ++i) {
            jsonObj = (JSONObject)list.get(i);
            mJSONArray_.add((Object)jsonObj);
        }
        return mJSONArray_;
    }

    public static JSONArray filterJson(JSONArray array, String remove) {
        JSONArray array_ = new JSONArray();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject obj = array.getJSONObject(i);
            obj = JsonUtil.filterJson(obj, remove);
            array_.add((Object)obj);
        }
        return array_;
    }

    public static JSONObject filterJson(JSONObject obj, String remove) {
        String[] rs;
        for (String string : rs = StringUtil.StringToArray(remove, ",")) {
            obj.remove((Object)string);
        }
        return obj;
    }

    public static String formatJson(String jsonStr) {
        if (null == jsonStr || "".equals(jsonStr)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        char last = '\u0000';
        char current = '\u0000';
        int indent = 0;
        block5: for (int i = 0; i < jsonStr.length(); ++i) {
            last = current;
            current = jsonStr.charAt(i);
            switch (current) {
                case '[': 
                case '{': {
                    sb.append(current);
                    sb.append('\n');
                    JsonUtil.addIndentBlank(sb, ++indent);
                    continue block5;
                }
                case ']': 
                case '}': {
                    sb.append('\n');
                    JsonUtil.addIndentBlank(sb, --indent);
                    sb.append(current);
                    continue block5;
                }
                case ',': {
                    sb.append(current);
                    if (last == '\\') continue block5;
                    sb.append('\n');
                    JsonUtil.addIndentBlank(sb, indent);
                    continue block5;
                }
                default: {
                    sb.append(current);
                }
            }
        }
        return sb.toString();
    }

    private static void addIndentBlank(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append("  ");
        }
    }

    public static JSONObject toJSONObject(JSONArray jsonArray, String key) {
        JSONObject jsonObject = new JSONObject();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject temp = jsonArray.getJSONObject(i);
            String[] keyValues = StringUtil.StringToArray(key);
            if (keyValues == null) continue;
            for (String item : keyValues) {
                String[] k = item.split(":");
                String[] keys = k[0].split("_");
                String keyName = k[0];
                if (keys.length == 2) {
                    keyName = keys[0];
                }
                String jsonKeyName = temp.getString(keyName);
                if (keys.length == 2) {
                    jsonKeyName = jsonKeyName + "_" + keys[1];
                }
                jsonObject.put(jsonKeyName, (Object)temp.getString(k[1]));
            }
        }
        return jsonObject;
    }

    public static class JsonComparator
    implements Comparator<JSONObject> {
        String dateName = "";
        String way = "desc";

        JsonComparator(String dateName) {
            this.dateName = dateName;
        }

        JsonComparator(String dateName, String way) {
            this.dateName = dateName;
        }

        @Override
        public int compare(JSONObject json1, JSONObject json2) {
            String date1 = json1.getString(this.dateName);
            String date2 = json2.getString(this.dateName);
            System.out.println(date1 + "  " + date2);
            if (date1.compareTo(date2) < 0) {
                return "desc".equalsIgnoreCase(this.way) ? -1 : 1;
            }
            if (date1.compareTo(date2) > 0) {
                return "desc".equalsIgnoreCase(this.way) ? 1 : -1;
            }
            return 0;
        }
    }
}

