/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.util.util;

import cn.jiangzeyin.util.util.OrderedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;

public class PropertiesUtil {
    private static final HashMap<String, PropertiesInfo> MAP = new HashMap();

    public static OrderedProperties getProperties(String name) throws URISyntaxException, IOException {
        URL url = PropertiesUtil.class.getResource(name);
        return PropertiesUtil.getProperties(url);
    }

    public static OrderedProperties getProperties(URL url) throws IOException, URISyntaxException {
        String type = url.getProtocol();
        if (type.equals("file")) {
            File file = new File(url.toURI());
            return PropertiesUtil.getProperties(file);
        }
        if (type.equals("jar")) {
            PropertiesInfo propertiesInfo = MAP.get(url.toString());
            if (propertiesInfo == null) {
                propertiesInfo = new PropertiesInfo();
                InputStream inputStream = url.openStream();
                OrderedProperties properties = new OrderedProperties();
                properties.load(inputStream);
                inputStream.close();
                propertiesInfo.setProperties(properties);
            }
            return propertiesInfo.getProperties();
        }
        throw new IllegalArgumentException("\u6ca1\u6709\u5bf9\u5e94\u7c7b\u578b");
    }

    public static OrderedProperties getProperties(File file) throws URISyntaxException, IOException {
        PropertiesInfo propertiesInfo = MAP.get(file.getPath());
        if (propertiesInfo == null) {
            propertiesInfo = new PropertiesInfo();
            FileInputStream inputStream = new FileInputStream(file);
            OrderedProperties properties = new OrderedProperties(file);
            properties.load(inputStream);
            ((InputStream)inputStream).close();
            propertiesInfo.setFile(file);
            propertiesInfo.setLastModified(file.lastModified());
            propertiesInfo.setProperties(properties);
            MAP.put(file.getPath(), propertiesInfo);
        } else if (propertiesInfo.getFile().lastModified() != propertiesInfo.getLastModified()) {
            FileInputStream in = new FileInputStream(propertiesInfo.getFile());
            OrderedProperties properties = propertiesInfo.getProperties();
            properties.load(in);
            ((InputStream)in).close();
        }
        return propertiesInfo.getProperties();
    }

    public static class PropertiesInfo {
        private OrderedProperties properties;
        private long lastModified;
        private File file;

        public OrderedProperties getProperties() {
            return this.properties;
        }

        public void setProperties(OrderedProperties properties) {
            this.properties = properties;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }
    }
}

