/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.util.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

public final class StringUtil {
    private static final String CONFIG_LOCATION_DELIMITERS = ",; \t\n";

    public static final boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static boolean isChinese(String strName) {
        char[] ch;
        for (char c : ch = strName.toCharArray()) {
            if (!StringUtil.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    public static int isInteger(String str) {
        int res = 1;
        if (str == null || "".equals(str)) {
            return 1;
        }
        if (Pattern.matches("^[0-9]*$", str)) {
            res = Integer.parseInt(str);
        }
        return res;
    }

    public static boolean notEmptyIsValidity(String data, int maxLength, int minLength) {
        if (data == null) {
            return false;
        }
        data = data.replaceAll("\u3000", "");
        data = data.trim();
        if ("".equals(data = StringUtil.compileHtml(data)) || data.length() == 0) {
            return false;
        }
        if (maxLength == 0 || minLength == 0) {
            return true;
        }
        return data.length() <= maxLength && data.length() >= minLength;
    }

    public static String cleanPath(String str) {
        if (str != null && !"".equals(str)) {
            if (str.contains("\\")) {
                str = str.replace("\\", "/");
            }
            if (str.contains("//")) {
                str.replace("//", "/");
            }
        }
        return str;
    }

    public static boolean isEmpty(String data, int minLength, int maxLength) {
        if (data == null) {
            return true;
        }
        if ((data = data.trim()).isEmpty()) {
            return true;
        }
        if ((data = data.replaceAll("\u3000", "")).isEmpty()) {
            return true;
        }
        if ((data = StringUtil.compileHtml(data)).isEmpty()) {
            return true;
        }
        if (maxLength <= 0 || minLength <= 0) {
            return false;
        }
        if (minLength > maxLength) {
            minLength ^= maxLength;
            maxLength = minLength ^ maxLength;
            minLength ^= maxLength;
        }
        return data.length() > maxLength || data.length() < minLength;
    }

    public static boolean isEmpty(String data) {
        return StringUtil.isEmpty(data, -1, -1);
    }

    public static String filterHTML(String input) {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return input;
        }
        input = input.trim();
        input = input.replaceAll("<", "&lt;");
        input = input.replaceAll(">", "&gt;");
        input = input.replaceAll("'", "&#39;");
        return input;
    }

    public static String filterHTML2(String input) {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return input;
        }
        input = input.trim();
        input = input.replaceAll("&", "&amp;");
        return input;
    }

    public static String compileHtml(String input) {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return input;
        }
        input = input.replaceAll("&amp;", "&");
        input = input.replaceAll("&lt;", "<");
        input = input.replaceAll("&gt;", ">");
        input = input.replaceAll("&nbsp;", " ");
        input = input.replaceAll("&#39;", "'");
        input = input.replaceAll("&quot;", "\"");
        return input.replaceAll("<br>", "\n");
    }

    public static String compileStr(String input) {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return input;
        }
        input = input.replaceAll("\n", "<br>");
        input = input.replaceAll("\t", "  ");
        input = input.replaceAll("\\\"", "\"");
        return input;
    }

    public static String compileHtml2(String input) {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return input;
        }
        input = input.replaceAll("&lt;", "<");
        input = input.replaceAll("&gt;", ">");
        input = input.replaceAll("&nbsp;", " ");
        input = input.replaceAll("&quot;", "\"");
        return input.replaceAll("<br>", "\n");
    }

    public static String sql_inj(String str) {
        String inj_str = "':and:exec:insert:select:delete:update:count:*:%:chr:mid:master:truncate:char:declare:;:or:-:+:,";
        String[] inj_stra = inj_str.split(":");
        for (int i = 0; i < inj_stra.length; ++i) {
            try {
                str = str.replaceAll(inj_stra[i], "?");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return str;
    }

    public static String sql_likeTo(String str) {
        StringBuffer sBuffer = new StringBuffer(str);
        for (int i = 0; i < str.length(); ++i) {
            sBuffer.insert(i * 2, "%");
        }
        sBuffer.insert(sBuffer.length(), "%");
        return sBuffer.toString();
    }

    public static String RemoveStringInterval(CharSequence sequence, String interval) {
        String string = sequence.toString().trim();
        if (string.startsWith(interval)) {
            string = string.substring(1);
        }
        if (string.endsWith(interval)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String RemoveStringInterval(CharSequence sequence) {
        return StringUtil.RemoveStringInterval(sequence, ",");
    }

    public static String[] StringToArray(String str) {
        return StringUtil.StringToArray(str, CONFIG_LOCATION_DELIMITERS);
    }

    public static String[] StringToArray(String str, String separator) {
        if (str == null || separator == null) {
            return null;
        }
        int i = 0;
        StringTokenizer st = new StringTokenizer(str, separator);
        String[] array = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            array[i++] = st.nextToken();
        }
        return array;
    }

    public static ArrayList<String> StringToArrayList(String str, String separator) {
        ArrayList<String> arr = new ArrayList<String>();
        if (str == null || separator == null) {
            return arr;
        }
        StringTokenizer st = new StringTokenizer(str, separator);
        while (st.hasMoreTokens()) {
            arr.add(st.nextToken());
        }
        return arr;
    }

    public static int[] StringToIntArray(String str, String separator) {
        if (str == null || separator == null) {
            return null;
        }
        int i = 0;
        StringTokenizer st = new StringTokenizer(str, separator);
        int[] array = new int[st.countTokens()];
        while (st.hasMoreTokens()) {
            array[i++] = StringUtil.parseInt(st.nextToken());
        }
        return array;
    }

    public static int parseInt(String num) {
        return StringUtil.parseInt(num, 0);
    }

    public static int parseInt(Object num) {
        if (num == null) {
            return 0;
        }
        return StringUtil.parseInt(num.toString(), 0);
    }

    public static int parseInt(Object obj, int default_) {
        return StringUtil.parseInt(StringUtil.convertNULL(obj), default_);
    }

    public static int parseInt(String num, int default_) {
        if (num == null || num.length() == 0) {
            return default_;
        }
        try {
            return Integer.parseInt(num);
        }
        catch (NumberFormatException numberFormatException) {
            return default_;
        }
    }

    public static long parseLong(String num) {
        if (num == null) {
            return 0L;
        }
        try {
            return Long.parseLong(num);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public static float parseFloat(String num) {
        if (num == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(num);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0f;
        }
    }

    public static double parseDouble(String num) {
        if (num == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(num);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public static String getUTF8(String str) {
        if (StringUtil.isEmpty(str)) {
            return "";
        }
        try {
            return new String(str.getBytes("ISO-8859-1"), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String getEncoding(String str) {
        String encode = "GB2312";
        try {
            if (str.equals(new String(str.getBytes(encode), encode))) {
                String s = encode;
                return s;
            }
        }
        catch (Exception s) {
            // empty catch block
        }
        encode = "ISO-8859-1";
        try {
            if (str.equals(new String(str.getBytes(encode), encode))) {
                String s1 = encode;
                return s1;
            }
        }
        catch (Exception s1) {
            // empty catch block
        }
        encode = "UTF-8";
        try {
            if (str.equals(new String(str.getBytes(encode), encode))) {
                String s2 = encode;
                return s2;
            }
        }
        catch (Exception s2) {
            // empty catch block
        }
        encode = "GBK";
        try {
            if (str.equals(new String(str.getBytes(encode), encode))) {
                String s3 = encode;
                return s3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String convertUTF8(String input) throws UnsupportedEncodingException {
        if (input == null) {
            return "";
        }
        return new String(input.getBytes(StringUtil.getEncoding(input)), "UTF-8");
    }

    public static String convertNULL(String input) {
        if (input == null) {
            return "";
        }
        return input.trim().intern();
    }

    public static String convertNULL(Object input) {
        if (input == null) {
            return "";
        }
        return StringUtil.convertNULL(input.toString());
    }

    public static StringBuffer replaceAll(StringBuffer sb, String oldStr, String newStr) {
        int i = sb.indexOf(oldStr);
        int oldLen = oldStr.length();
        int newLen = newStr.length();
        while (i > -1) {
            sb.delete(i, i + oldLen);
            sb.insert(i, newStr.intern());
            i = sb.indexOf(oldStr.intern(), i + newLen);
        }
        return sb;
    }

    public static boolean isCharacters(String str) {
        char[] chars = str.toCharArray();
        boolean isGB2312 = false;
        for (int i = 0; i < chars.length; ++i) {
            int[] ints;
            byte[] bytes = ("" + chars[i]).getBytes();
            if (bytes.length != 2 || (ints = new int[]{bytes[0] & 0xFF, bytes[1] & 0xFF})[0] < 129 || ints[0] > 254 || ints[1] < 64 || ints[1] > 254) continue;
            isGB2312 = true;
            break;
        }
        return isGB2312;
    }

    public static String exChange(String str) {
        StringBuffer sb = new StringBuffer();
        if (str != null) {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c >= '0' && c <= '9') {
                    sb.append(c);
                    continue;
                }
                if (Character.isUpperCase(c)) {
                    sb.append(Character.toLowerCase(c));
                    continue;
                }
                if (Character.isLowerCase(c)) {
                    sb.append(Character.toUpperCase(c));
                    continue;
                }
                sb.append(c);
            }
        }
        return sb.toString();
    }

    public static String captureName(String inString) {
        if (StringUtil.isEmpty(inString)) {
            return "";
        }
        if (inString.length() > 1) {
            return inString.substring(0, 1).toUpperCase() + inString.substring(1);
        }
        return inString.toUpperCase();
    }

    public static String fromException(Throwable e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return "\r\n" + sw.toString() + "\r\n";
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String replaceChinese(String source, String replacement) {
        if (StringUtil.isEmpty(source)) {
            return "";
        }
        if (StringUtil.isEmpty(replacement)) {
            throw new IllegalArgumentException("not null");
        }
        String reg = "[\u4e00-\u9fa5]";
        Pattern pat = Pattern.compile(reg);
        Matcher mat = pat.matcher(source);
        return mat.replaceAll(replacement);
    }

    public static String maskPhone(String mobile) {
        StringBuilder newPhone = new StringBuilder();
        for (int i = 0; i < mobile.length(); ++i) {
            if (i == mobile.length() - 11) {
                newPhone.append(mobile.charAt(i));
                continue;
            }
            if (i == mobile.length() - 10) {
                newPhone.append(mobile.charAt(i));
                continue;
            }
            if (i == mobile.length() - 9) {
                newPhone.append(mobile.charAt(i));
                continue;
            }
            if (i == mobile.length() - 4) {
                newPhone.append(mobile.charAt(i));
                continue;
            }
            if (i == mobile.length() - 3) {
                newPhone.append(mobile.charAt(i));
                continue;
            }
            if (i == mobile.length() - 2) {
                newPhone.append(mobile.charAt(i));
                continue;
            }
            if (i == mobile.length() - 1) {
                newPhone.append(mobile.charAt(i));
                continue;
            }
            newPhone.append("*");
        }
        return newPhone.toString();
    }

    public static String arrayToString(String[] strings) {
        Assert.notNull((Object)strings);
        StringBuilder stringBuffer = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(strings[i]);
        }
        return stringBuffer.toString();
    }

    public static String filtrateMysqlLikeSql(String value) {
        if (null != value) {
            String newValue = "";
            newValue = value.replaceAll("\\\\", "\\\\\\\\");
            newValue = newValue.replaceAll("'", "\\\\'");
            newValue = newValue.replaceAll("_", "\\\\_");
            newValue = newValue.replaceAll("\"", "\\\\\"");
            newValue = newValue.replaceAll("%", "\\\\%");
            return newValue;
        }
        return null;
    }
}

