/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.util.util.date;

import cn.jiangzeyin.util.util.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public final class DateUtil {
    public static String FormatTimeStamp(String pattern, long date) {
        if (pattern == null || pattern.length() == 0) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        GregorianCalendar nowDate = new GregorianCalendar();
        nowDate.setTimeInMillis(date * 1000L);
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.format(nowDate.getTime());
    }

    public static String FormatTime(String pattern, long date) {
        if (pattern == null || pattern.length() == 0) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    public static String getCurrentTime() {
        return DateUtil.FormatTimeStamp("", System.currentTimeMillis() / 1000L);
    }

    public static long getCurrentUnixTime() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long getFromTime(String startDate, String startTime) {
        long fromtime = 0L;
        if (StringUtil.isEmpty(startTime)) {
            startTime = "00:00";
        }
        if (!startDate.equals("")) {
            String[] s = startDate.split("-");
            GregorianCalendar nowDate = new GregorianCalendar();
            nowDate.set(5, Integer.parseInt(s[2]));
            nowDate.set(2, Integer.parseInt(s[1]) - 1);
            nowDate.set(1, Integer.parseInt(s[0]));
            String[] t = startTime.split(":");
            nowDate.set(11, Integer.parseInt(t[0]));
            nowDate.set(12, Integer.parseInt(t[1]));
            nowDate.set(13, 0);
            fromtime = nowDate.getTimeInMillis() / 1000L;
        }
        return fromtime;
    }

    public static Date FormatTimeStamp(long date) {
        GregorianCalendar nowDate = new GregorianCalendar();
        nowDate.setTimeInMillis(date * 1000L);
        return nowDate.getTime();
    }

    public static int getCurrentMonthDay() {
        Calendar a = Calendar.getInstance();
        a.set(5, 1);
        a.roll(5, -1);
        int maxDate = a.get(5);
        return maxDate;
    }

    public static int getDaysByYearMonth(int year, int month) {
        Calendar a = Calendar.getInstance();
        a.set(1, year);
        a.set(2, month - 1);
        a.set(5, 1);
        a.roll(5, -1);
        int maxDate = a.get(5);
        return maxDate;
    }

    public static String getDayOfWeekByDate(String date) {
        String dayOfweek = "-1";
        try {
            String str;
            SimpleDateFormat myFormatter = new SimpleDateFormat("yyyy-MM-dd");
            Date myDate = myFormatter.parse(date);
            SimpleDateFormat formatter = new SimpleDateFormat("E");
            dayOfweek = str = formatter.format(myDate);
        }
        catch (Exception e) {
            System.out.println("\u9519\u8bef!");
        }
        return dayOfweek;
    }

    public static boolean checkTimeDiff(long data, long d) {
        long diff = System.currentTimeMillis() - (data *= 1000L);
        return diff > d;
    }

    public static long fromDate(String pattern, String time) throws ParseException {
        if (pattern == null || pattern.length() == 0) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        Date date = df.parse(time);
        return date.getTime();
    }

    public static Date getDateBefore(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) - day);
        return now.getTime();
    }

    public static String getDateBefore(String pattern, Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) - day);
        if (pattern == null || pattern.length() == 0) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.format(now.getTime());
    }

    public static Date getDateAfter(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) + day);
        return now.getTime();
    }

    public static String getFormat(Date date) {
        if (date == null) {
            return "\u6682\u65f6\u65e0\u65f6\u95f4\u8bb0\u5f55";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public static String transferLongToDate(String dateFormat, long millSec) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        Date date = new Date(millSec);
        return sdf.format(date);
    }

    public static int dateToStamp(String s) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = simpleDateFormat.parse(s);
        return (int)(date.getTime() / 1000L);
    }

    public static int getDateMonth(long dateNum) {
        String date = DateUtil.transferLongToDate("yyyy-MM-dd HH:mm:ss", dateNum);
        int monthIndex = StringUtil.parseInt(date.substring(5, 7));
        return monthIndex;
    }

    public static int getDateYear(long dateNum) {
        String date = DateUtil.transferLongToDate("yyyy-MM-dd HH:mm:ss", dateNum);
        int monthIndex = StringUtil.parseInt(date.substring(0, 4));
        if (monthIndex <= 0) {
            return 0;
        }
        return monthIndex;
    }

    public static long getTimeStampByYearMonthAndDay(int year, int month, int day) throws ParseException {
        String year_ = year + "";
        String month_ = "";
        String day_ = "";
        month_ = month < 10 ? "0" + month : "" + month;
        day_ = day < 10 ? "0" + day : "" + day;
        String dateTime = year_ + month_ + day_;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        Date date = df.parse(dateTime);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getTimeInMillis() / 1000L;
    }
}

