/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.util.util.file;

import cn.jiangzeyin.util.util.file.FileType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.util.Assert;

public abstract class FileStreamUtil {
    public static InputStream copyInputStream(InputStream input) throws Exception {
        int len;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = input.read(buffer)) > -1) {
            byteArrayOutputStream.write(buffer, 0, len);
        }
        byteArrayOutputStream.flush();
        ByteArrayInputStream stream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        return stream;
    }

    public static FileType getFileType(InputStream is) throws IOException {
        FileType[] fileTypes;
        Assert.notNull((Object)is);
        byte[] src = new byte[28];
        is.read(src, 0, 28);
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v).toUpperCase();
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        for (FileType fileType : fileTypes = FileType.values()) {
            if (!stringBuilder.toString().startsWith(fileType.getValue())) continue;
            return fileType;
        }
        return null;
    }
}

