/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.util.util.file;

import cn.jiangzeyin.util.system.util.UtilSystemCache;
import cn.jiangzeyin.util.util.RandomUtil;
import cn.jiangzeyin.util.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.Properties;
import org.springframework.util.Assert;

public final class FileUtil {
    public static Properties getProperties(String path) throws IOException {
        Properties prop = new Properties();
        FileInputStream in = new FileInputStream(path);
        prop.load(in);
        return prop;
    }

    public static String getFormatSize(long size) {
        double kiloByte = size / 1024L;
        if (kiloByte < 1.0) {
            return size + "Byte";
        }
        double megaByte = kiloByte / 1024.0;
        if (megaByte < 1.0) {
            BigDecimal result1 = new BigDecimal(Double.toString(kiloByte));
            return result1.setScale(2, 4).toPlainString() + "KB";
        }
        double gigaByte = megaByte / 1024.0;
        if (gigaByte < 1.0) {
            BigDecimal result2 = new BigDecimal(Double.toString(megaByte));
            return result2.setScale(2, 4).toPlainString() + "MB";
        }
        double teraBytes = gigaByte / 1024.0;
        if (teraBytes < 1.0) {
            BigDecimal result3 = new BigDecimal(Double.toString(gigaByte));
            return result3.setScale(2, 4).toPlainString() + "GB";
        }
        BigDecimal result4 = new BigDecimal(teraBytes);
        return result4.setScale(2, 4).toPlainString() + "TB";
    }

    public static boolean exists(String path) {
        File f = new File(path);
        return f.exists();
    }

    public static boolean mkdirs(String path) {
        return FileUtil.mkdirs(new File(path), path.endsWith("/"));
    }

    public static boolean mkdirs(File file, boolean isPath) {
        if (file == null) {
            return false;
        }
        if (isPath) {
            return file.mkdirs();
        }
        return file.getParentFile().mkdirs();
    }

    public static boolean mkdirs(File file) {
        return FileUtil.mkdirs(file, false);
    }

    public static String readToString(File file, String encoding) throws IOException {
        StringBuffer stringBuffer = null;
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
        String line = null;
        stringBuffer = new StringBuffer();
        while ((line = br.readLine()) != null) {
            stringBuffer.append(line);
        }
        br.close();
        return stringBuffer.toString();
    }

    public static String readToString(File file) throws IOException {
        return FileUtil.readToString(file, "UTF-8");
    }

    public static String getFileEncode(String path) throws IOException {
        String charset = "asci";
        byte[] first3Bytes = new byte[3];
        boolean checked = false;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(path));
        bis.mark(0);
        int read = bis.read(first3Bytes, 0, 3);
        if (read == -1) {
            return charset;
        }
        if (first3Bytes[0] == -1 && first3Bytes[1] == -2) {
            charset = "Unicode";
            checked = true;
        } else if (first3Bytes[0] == -2 && first3Bytes[1] == -1) {
            charset = "Unicode";
            checked = true;
        } else if (first3Bytes[0] == -17 && first3Bytes[1] == -69 && first3Bytes[2] == -65) {
            charset = "UTF8";
            checked = true;
        }
        bis.reset();
        if (!checked) {
            while ((read = bis.read()) != -1 && read < 240 && (128 > read || read > 191)) {
                if (192 <= read && read <= 223) {
                    read = bis.read();
                    if (128 > read || read > 191) break;
                    continue;
                }
                if (224 > read || read > 239) continue;
                read = bis.read();
                if (128 > read || read > 191 || 128 > (read = bis.read()) || read > 191) break;
                charset = "UTF-8";
                break;
            }
        }
        bis.close();
        return charset;
    }

    public static String readFile(String path) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        String data = null;
        String code = FileUtil.getFileEncode(path);
        InputStreamReader isr = null;
        if ("asci".equals(code)) {
            code = "GBK";
        }
        isr = new InputStreamReader((InputStream)new FileInputStream(file), code);
        int length = -1;
        char[] buffer = new char[1024];
        StringBuffer sb = new StringBuffer();
        while ((length = isr.read(buffer, 0, 1024)) != -1) {
            sb.append(buffer, 0, length);
        }
        data = new String(sb);
        isr.close();
        return data;
    }

    public static String readToString(String fileName, String encoding) throws Exception {
        File file = new File(fileName);
        Long filelength = file.length();
        byte[] filecontent = new byte[filelength.intValue()];
        FileInputStream in = new FileInputStream(file);
        in.read(filecontent);
        in.close();
        return new String(filecontent, encoding);
    }

    public static String readToString(String fileName) throws Exception {
        return FileUtil.readToString(fileName, "UTF-8");
    }

    public static void writeFile(String fileName, String content) throws IOException {
        FileUtil.appendFileContext(fileName, content, false);
    }

    public static void appendFileContext(String fileName, String content) throws IOException {
        FileUtil.appendFileContext(fileName, content, true);
    }

    public static void appendFileContext(String fileName, String content, boolean append) throws IOException {
        File file = new File(fileName);
        file.getParentFile().mkdirs();
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
        if (content != null) {
            out.write(content);
        }
        ((Writer)out).close();
    }

    public static boolean writeInputStream(InputStream inputStream, String path) throws IOException {
        return FileUtil.writeInputStream(inputStream, new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeInputStream(InputStream inputStream, File file) throws IOException {
        Assert.notNull((Object)inputStream);
        Assert.notNull((Object)file);
        FileUtil.mkdirs(file);
        DataOutputStream outputStream = null;
        try {
            outputStream = new DataOutputStream(new FileOutputStream(file));
            int len = inputStream.available();
            if (len <= 0x100000) {
                byte[] bytes = new byte[len];
                inputStream.read(bytes);
                outputStream.write(bytes);
            } else {
                int byteCount = 0;
                byte[] bytes = new byte[0x100000];
                while ((byteCount = inputStream.read(bytes)) != -1) {
                    outputStream.write(bytes, 0, byteCount);
                }
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return true;
    }

    public static String getCharset(InputStream ins) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(ins);
        int p = (bin.read() << 8) + bin.read();
        String code = null;
        switch (p) {
            case 61371: {
                code = "UTF-8";
                break;
            }
            case 65534: {
                code = "Unicode";
                break;
            }
            case 65279: {
                code = "UTF-16BE";
                break;
            }
            default: {
                code = "GBK";
            }
        }
        ins.close();
        bin.close();
        return code;
    }

    public static String getFileCharset(String fileName) throws IOException {
        FileInputStream ins = new FileInputStream(fileName);
        return FileUtil.getCharset(ins);
    }

    public static String getFilePath(String path) {
        File file = new File(path);
        return FileUtil.getFilePath(file);
    }

    public static String getFilePath(File file) {
        return FileUtil.clearPath(file.getParent());
    }

    public static String getFileExt(String filename) {
        String ext = "";
        int index = filename.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        ext = filename.substring(index + 1);
        return ext;
    }

    public static String clearPath(String input) {
        input = input.replace('\\', '/');
        return FileUtil.clearPath_(input);
    }

    public static String getFileName(String filename) {
        String ext = "";
        int index = filename.lastIndexOf("/");
        if (index == -1) {
            return filename;
        }
        ext = filename.substring(index + 1);
        return ext;
    }

    private static String clearPath_(String input) {
        int i;
        int from = 0;
        int j = input.indexOf("://");
        if (j != -1) {
            from = j + 3;
        }
        if ((i = input.indexOf("//", from)) == -1) {
            return input;
        }
        String input_ = input.substring(0, i) + "/" + input.substring(i + 2);
        return FileUtil.clearPath_(input_);
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < (children != null ? children.length : 0); ++i) {
                boolean success = FileUtil.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static LinkedList<File> getFolderFiles(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        if (!file.isDirectory()) {
            return null;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return null;
        }
        LinkedList<File> linkedList = new LinkedList<File>();
        for (File item : files) {
            if (item.isDirectory()) {
                LinkedList<File> tempFile = FileUtil.getFolderFiles(item.getPath());
                if (tempFile == null) continue;
                linkedList.addAll(tempFile);
                continue;
            }
            linkedList.add(item);
        }
        return linkedList;
    }

    public static boolean deleteDir(String dir) {
        return FileUtil.deleteDir(new File(dir));
    }

    public static String getFilePathName(String siteTag, String path_, String ext) {
        path_ = StringUtil.convertNULL(path_);
        StringBuffer sb = new StringBuffer("/");
        sb.append(path_ + "/");
        Calendar cal = Calendar.getInstance();
        sb.append(cal.get(1));
        sb.append("/");
        String f = "%02d";
        f = String.format(f, cal.get(2) + 1);
        sb.append(f);
        sb.append("/");
        f = "%02d";
        f = String.format(f, cal.get(5));
        sb.append(f);
        sb.append("/");
        String root = UtilSystemCache.getInstance().getLocalPath(siteTag);
        int length = 15;
        String name = RandomUtil.getBoundry(length) + "." + ext;
        while (true) {
            String path = FileUtil.clearPath(root + sb.toString() + name);
            File file = new File(path);
            file.getParentFile().mkdirs();
            if (!file.exists()) break;
            name = RandomUtil.getBoundry(++length) + "." + ext;
        }
        sb.append(name);
        return FileUtil.clearPath(sb.toString());
    }

    public static String getFilePathName(String siteTag, String ext, long time) {
        StringBuilder sb = new StringBuilder("/");
        Calendar cal = Calendar.getInstance();
        sb.append(cal.get(1));
        sb.append("/");
        String f = "%02d";
        f = String.format(f, cal.get(2) + 1);
        sb.append(f);
        sb.append("/");
        f = "%02d";
        f = String.format(f, cal.get(5));
        sb.append(f);
        sb.append("/");
        String root = UtilSystemCache.getInstance().getLocalPath(siteTag);
        String name = time + "." + ext;
        while (true) {
            String path = FileUtil.clearPath(root + sb.toString() + name);
            FileUtil.mkdirs(path);
            if (!FileUtil.exists(path)) break;
            name = (time += (long)RandomUtil.getRandomCode(2)) + "." + ext;
        }
        sb.append(name);
        return sb.toString();
    }

    public static String getFilePathName(String sitetag, String ext) {
        return FileUtil.getFilePathName(sitetag, "", ext);
    }
}

