/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.util.util.images;

import cn.jiangzeyin.util.util.RandomUtil;
import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public final class ImageUtil {
    public static Object[] getRandomCode() throws IOException {
        int width = 90;
        int height = 35;
        int codeCount = 4;
        int xx = 15;
        int fontHeight = 35;
        int codeY = 30;
        Object[] obj = new Object[2];
        BufferedImage buffImg = new BufferedImage(width, height, 1);
        Graphics gd = buffImg.getGraphics();
        gd.setColor(Color.WHITE);
        gd.fillRect(0, 0, width, height);
        Font font = new Font("Fixedsys", 1, fontHeight);
        gd.setFont(font);
        gd.setColor(Color.WHITE);
        gd.drawRect(0, 0, width - 1, height - 1);
        gd.setColor(Color.BLACK);
        for (int i = 0; i < 10; ++i) {
            int x = RandomUtil.rand.nextInt(width);
            int y = RandomUtil.rand.nextInt(height);
            int xl = RandomUtil.rand.nextInt(12);
            int yl = RandomUtil.rand.nextInt(12);
            gd.drawLine(x, y, x + xl, y + yl);
        }
        StringBuffer randomCode = new StringBuffer();
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int i = 0; i < codeCount; ++i) {
            String code = String.valueOf((char)RandomUtil.getCodeAscll());
            red = RandomUtil.rand.nextInt(180);
            green = RandomUtil.rand.nextInt(200);
            blue = RandomUtil.rand.nextInt(150);
            gd.setColor(new Color(red, green, blue));
            if (i == 0) {
                gd.drawString(code, 5, codeY);
            } else {
                gd.drawString(code, (i + 1) * xx, codeY);
            }
            randomCode.append(code);
        }
        obj[0] = buffImg;
        obj[1] = randomCode.toString();
        return obj;
    }

    public static boolean ImageIsTrue(String path) {
        try {
            BufferedImage bi = ImageIO.read(new File(path));
            return bi != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static BufferedImage getBufferedImage(String imgUrl) throws IOException {
        URL url = new URL(imgUrl);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        if (con.getResponseCode() == 302) {
            String redictURL = con.getHeaderField("Location");
            return ImageUtil.getBufferedImage(redictURL);
        }
        InputStream is = url.openStream();
        BufferedImage img = ImageIO.read(is);
        is.close();
        con.disconnect();
        return img;
    }

    public static boolean downloadImageUrl(String imgUrl, String imgdist, int width, int height) throws IOException {
        BufferedImage image = ImageUtil.getBufferedImage(imgUrl);
        if (width == -1 || height == -1) {
            return ImageUtil.writeImage(image, imgdist);
        }
        ImageUtil.reduceImg(image, imgdist, width, height);
        return true;
    }

    public static boolean downloadImageUrl(String imgUrl, String imgdist) throws IOException {
        return ImageUtil.downloadImageUrl(imgUrl, imgdist, -1, -1);
    }

    public static void reduceImg(BufferedImage src, String imgdist, int widthdist, int heightdist) throws ImageFormatException, IOException {
        BufferedImage tag = new BufferedImage(widthdist, heightdist, 1);
        tag.getGraphics().drawImage(src.getScaledInstance(widthdist, heightdist, 4), 0, 0, null);
        FileOutputStream out = new FileOutputStream(imgdist);
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
        encoder.encode(tag);
        out.close();
    }

    public static boolean writeImage(BufferedImage image, String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        ImageIO.write((RenderedImage)image, "JPEG", file);
        return true;
    }

    public static void resize(File originalFile, File resizedFile, int newWidth, float quality) throws IOException {
        int iHeight;
        if (quality > 1.0f) {
            throw new IllegalArgumentException("Quality has to be between 0 and 1");
        }
        ImageIcon ii = new ImageIcon(originalFile.getCanonicalPath());
        Image i = ii.getImage();
        Image resizedImage = null;
        int iWidth = i.getWidth(null);
        resizedImage = iWidth > (iHeight = i.getHeight(null)) ? i.getScaledInstance(newWidth, newWidth * iHeight / iWidth, 4) : i.getScaledInstance(newWidth * iWidth / iHeight, newWidth, 4);
        Image temp = new ImageIcon(resizedImage).getImage();
        BufferedImage bufferedImage = new BufferedImage(temp.getWidth(null), temp.getHeight(null), 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, temp.getWidth(null), temp.getHeight(null));
        g.drawImage(temp, 0, 0, null);
        g.dispose();
        float softenFactor = 0.05f;
        float[] softenArray = new float[]{0.0f, softenFactor, 0.0f, softenFactor, 1.0f - softenFactor * 4.0f, softenFactor, 0.0f, softenFactor, 0.0f};
        Kernel kernel = new Kernel(3, 3, softenArray);
        ConvolveOp cOp = new ConvolveOp(kernel, 1, null);
        bufferedImage = cOp.filter(bufferedImage, null);
        FileOutputStream out = new FileOutputStream(resizedFile);
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
        JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(bufferedImage);
        param.setQuality(quality, true);
        encoder.setJPEGEncodeParam(param);
        encoder.encode(bufferedImage);
    }

    public static int getWidth(String path) throws IOException {
        File picture = new File(path);
        if (!picture.exists()) {
            throw new IllegalArgumentException(path + " \u4e0d\u5b58\u5728");
        }
        BufferedImage sourceImg = ImageIO.read(new FileInputStream(picture));
        return sourceImg.getWidth();
    }

    public static int getHeight(String path) throws IOException {
        File picture = new File(path);
        if (!picture.exists()) {
            throw new IllegalArgumentException(path + " \u4e0d\u5b58\u5728");
        }
        BufferedImage sourceImg = ImageIO.read(new FileInputStream(picture));
        return sourceImg.getHeight();
    }

    public static boolean checkPx(String path, int width, int height) throws IOException {
        File picture = new File(path);
        if (!picture.exists()) {
            throw new IllegalArgumentException(path + " \u4e0d\u5b58\u5728");
        }
        return ImageUtil.checkPx(new FileInputStream(picture), width, height);
    }

    public static boolean checkPx(InputStream inputStream, int width, int height) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("is null");
        }
        BufferedImage sourceImg = ImageIO.read(inputStream);
        if (sourceImg.getWidth() != width) {
            return false;
        }
        return sourceImg.getHeight() == height;
    }
}

