/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common;

import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.PreLoadClass;
import cn.jiangzeyin.common.PreLoadMethod;
import cn.jiangzeyin.common.spring.SpringUtil;
import cn.jiangzeyin.util.PackageUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SystemInitPackageControl {
    public static void init() {
        String pageName = SpringUtil.getEnvironment().getProperty("preload.packageName");
        if (pageName == null || pageName.length() > 0) {
            return;
        }
        try {
            List<String> list = PackageUtil.getClassName(pageName);
            if (list == null || list.size() <= 0) {
                return;
            }
            ArrayList classList = new ArrayList();
            for (String name : list) {
                try {
                    Class<?> cls = Class.forName(name);
                    classList.add(cls);
                }
                catch (ClassNotFoundException e) {
                    DefaultSystemLog.ERROR().error("\u9884\u52a0\u8f7d\u5305\u9519\u8bef:" + name, (Throwable)e);
                }
            }
            if (classList.size() <= 0) {
                return;
            }
            List<Map.Entry<Integer, Class>> newList = SystemInitPackageControl.splitClass(classList);
            if (newList != null) {
                for (Map.Entry<Integer, Class> item : newList) {
                    SystemInitPackageControl.loadClass(item.getValue());
                }
            }
        }
        catch (IOException e) {
            DefaultSystemLog.ERROR().error("\u9884\u52a0\u8f7d\u5305\u9519\u8bef", (Throwable)e);
        }
    }

    private static List<Map.Entry<Integer, Class>> splitClass(List<Class<?>> list) {
        HashMap sortMap = new HashMap();
        for (Class<?> item : list) {
            PreLoadClass preLoadClass = item.getAnnotation(PreLoadClass.class);
            if (preLoadClass == null) continue;
            sortMap.put(preLoadClass.value(), item);
        }
        ArrayList newList = null;
        if (sortMap.size() > 0) {
            newList = new ArrayList(sortMap.entrySet());
            newList.sort(Comparator.comparing(Map.Entry::getKey));
        }
        return newList;
    }

    /*
     * WARNING - void declaration
     */
    private static void loadClass(Class classT) {
        Method method;
        void var5_7;
        Method[] methods = classT.getMethods();
        HashMap<Integer, Method> sortMap = new HashMap<Integer, Method>();
        Method[] methodArray = methods;
        int n = methodArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            PreLoadMethod preLoadMethod;
            method = methodArray[var5_7];
            if (Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers()) && (preLoadMethod = method.getAnnotation(PreLoadMethod.class)) != null) {
                sortMap.put(preLoadMethod.value(), method);
            }
            ++var5_7;
        }
        if (sortMap.size() > 0) {
            ArrayList newList = new ArrayList(sortMap.entrySet());
            newList.sort(Comparator.comparing(Map.Entry::getKey));
            for (Map.Entry entry : newList) {
                method = (Method)entry.getValue();
                try {
                    method.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    DefaultSystemLog.ERROR().error("\u9884\u52a0\u8f7d\u5305\u9519\u8bef:" + classT + "  " + method.getName() + "  \u6267\u884c\u9519\u8bef", (Throwable)e);
                }
            }
        }
    }
}

