/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.interceptor;

import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.interceptor.BaseInterceptor;
import cn.jiangzeyin.common.interceptor.InterceptorPattens;
import cn.jiangzeyin.util.PackageUtil;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableWebMvc
public class InterceptorControl
extends WebMvcConfigurerAdapter {
    @Value(value="${interceptor.initPackageName:}")
    private String loadPath;

    public void addInterceptors(InterceptorRegistry registry) {
        this.init(registry);
    }

    private void init(InterceptorRegistry registry) {
        List<String> list;
        if (this.loadPath == null || this.loadPath.length() <= 0) {
            return;
        }
        try {
            list = PackageUtil.getClassName(this.loadPath);
        }
        catch (IOException e) {
            DefaultSystemLog.ERROR().error("\u52a0\u8f7d\u62e6\u622a\u5668\u5f02\u5e38", (Throwable)e);
            return;
        }
        if (list == null) {
            return;
        }
        for (String item : list) {
            BaseInterceptor handlerInterceptor;
            InterceptorPattens interceptorPattens;
            boolean isAbstract;
            Class<?> classItem;
            try {
                classItem = Class.forName(item);
            }
            catch (ClassNotFoundException e) {
                DefaultSystemLog.ERROR().error("\u52a0\u8f7d\u62e6\u622a\u5668\u9519\u8bef", (Throwable)e);
                continue;
            }
            if (classItem == null || (isAbstract = Modifier.isAbstract(classItem.getModifiers())) || !BaseInterceptor.class.isAssignableFrom(classItem) || (interceptorPattens = classItem.getAnnotation(InterceptorPattens.class)) == null) continue;
            try {
                handlerInterceptor = (BaseInterceptor)((Object)classItem.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                DefaultSystemLog.ERROR().error("\u52a0\u8f7d\u62e6\u622a\u5668\u9519\u8bef", (Throwable)e);
                continue;
            }
            String[] patterns = interceptorPattens.value();
            registry.addInterceptor((HandlerInterceptor)handlerInterceptor).addPathPatterns(patterns);
            DefaultSystemLog.LOG().info("\u52a0\u8f7d\u62e6\u622a\u5668\uff1a" + classItem + "  " + patterns[0]);
        }
    }
}

