/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.spring;

import cn.jiangzeyin.common.BaseApplication;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.SystemInitPackageControl;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextStartedEvent;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.web.context.support.ServletRequestHandledEvent;

@Configuration
public class SpringUtil
implements ApplicationListener,
ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringUtil.applicationContext = applicationContext;
        DefaultSystemLog.init();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationReadyEvent) {
            SystemInitPackageControl.init();
            DefaultSystemLog.LOG().info("\u542f\u52a8\u5b8c\u6210");
            return;
        }
        if (event instanceof ContextStartedEvent) {
            System.out.println("3");
        } else if (event instanceof ContextStoppedEvent) {
            System.out.println("stop");
        } else if (event instanceof ContextClosedEvent) {
            DefaultSystemLog.LOG().info("\u5173\u95ed\u7a0b\u5e8f");
        } else if (event instanceof ServletRequestHandledEvent) {
            ServletRequestHandledEvent servletRequestHandledEvent = (ServletRequestHandledEvent)event;
            if (!servletRequestHandledEvent.wasFailure()) {
                DefaultSystemLog.LOG(DefaultSystemLog.LogType.REQUEST).info(servletRequestHandledEvent.toString());
            } else {
                DefaultSystemLog.LOG(DefaultSystemLog.LogType.REQUEST).info("error:" + servletRequestHandledEvent.toString());
            }
        } else if (!(event instanceof EmbeddedServletContainerInitializedEvent)) {
            System.out.println("else");
            System.out.println(event);
        }
    }

    public static ApplicationContext getApplicationContext() {
        Assert.notNull((Object)applicationContext, (String)"application is null");
        return applicationContext;
    }

    public static Object getBean(String name) {
        return SpringUtil.getApplicationContext().getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)SpringUtil.getApplicationContext().getBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)SpringUtil.getApplicationContext().getBean(name, clazz);
    }

    public static Environment getEnvironment() {
        return BaseApplication.getEnvironment();
    }

    public static String getApplicationId() {
        return SpringUtil.getEnvironment().getProperty("applicationId");
    }
}

