/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.spring;

import cn.jiangzeyin.common.spring.SpringUtil;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TomcatInitBean {
    @Bean
    public EmbeddedServletContainerCustomizer containerCustomizer() {
        return container -> {
            Integer timout = (Integer)SpringUtil.getEnvironment().getProperty("tomcat.sessionTimeOut", Integer.class);
            if (timout != null) {
                container.setSessionTimeout(timout.intValue(), TimeUnit.MINUTES);
            }
        };
    }

    @Bean
    public ServletContextInitializer servletContextInitializer() {
        return servletContext -> {
            String name = SpringUtil.getEnvironment().getProperty("tomcat.sessionCookieName");
            if (name != null && name.length() > 0) {
                servletContext.getSessionCookieConfig().setName(name);
            }
        };
    }
}

