/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.controller.base;

import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.spring.SpringUtil;
import cn.jiangzeyin.controller.base.RequestUtil;
import cn.jiangzeyin.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class AbstractBaseControl {
    private static final ThreadLocal<HttpServletRequest> HTTP_SERVLET_REQUEST_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<HttpSession> HTTP_SESSION_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<HttpServletResponse> HTTP_SERVLET_RESPONSE_THREAD_LOCAL = new ThreadLocal();
    protected String ip;
    private static String default_headerName = SpringUtil.getEnvironment().getProperty("ip.defaultHeaderName");

    public HttpServletResponse getResponse() {
        return HTTP_SERVLET_RESPONSE_THREAD_LOCAL.get();
    }

    public HttpSession getSession() {
        return HTTP_SESSION_THREAD_LOCAL.get();
    }

    public HttpServletRequest getRequest() {
        return HTTP_SERVLET_REQUEST_THREAD_LOCAL.get();
    }

    protected Object getAttribute(String name) {
        return this.getRequest().getAttribute(name);
    }

    protected void setAttribute(String name, Object object) {
        this.getRequest().setAttribute(name, object);
    }

    public void setReqAndRes(HttpServletRequest request, HttpSession session, HttpServletResponse response) {
        HTTP_SERVLET_REQUEST_THREAD_LOCAL.set(request);
        HTTP_SESSION_THREAD_LOCAL.set(session);
        HTTP_SERVLET_RESPONSE_THREAD_LOCAL.set(response);
        this.ip = AbstractBaseControl.getIpAddress(request);
        response.setCharacterEncoding("UTF-8");
    }

    protected String getHeader(String name) {
        return this.getRequest().getHeader(name);
    }

    public void reLoad() {
    }

    public String getSessionAttributeAfterRemove(String name) {
        Object obj = this.getSession().getAttribute(name);
        this.getSession().removeAttribute(name);
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    protected String getCookieValue(String name) {
        Cookie cookie = RequestUtil.getCookieByName(this.getRequest(), name);
        if (cookie == null) {
            return "";
        }
        return cookie.getValue();
    }

    protected String getParameter(String name) {
        return this.getParameter(name, null);
    }

    protected String[] getParameters(String name) {
        return this.getRequest().getParameterValues(name);
    }

    protected String getParameter(String name, String def) {
        String value = this.getRequest().getParameter(name);
        return value == null ? def : value;
    }

    protected int getParameterInt(String name, int def) {
        return StringUtil.parseInt(this.getParameter(name), def);
    }

    protected int getParameterInt(String name) {
        return this.getParameterInt(name, 0);
    }

    public <T> T getObject(Class<T> tClass) throws IllegalAccessException, InstantiationException {
        T obj = tClass.newInstance();
        this.doParameterMap(this.getRequest().getParameterMap(), obj);
        return obj;
    }

    void doParameterMap(Map<String, String[]> parameter, Object obj) {
        Iterator<Map.Entry<String, String[]>> entries = parameter.entrySet().iterator();
        Class<?> tClass = obj.getClass();
        while (entries.hasNext()) {
            Map.Entry<String, String[]> entry = entries.next();
            String key = entry.getKey();
            String[] value = entry.getValue();
            if (value == null) continue;
            String[] temp = value;
            StringBuilder stringBuffer = new StringBuilder();
            for (int i = 0; i < temp.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(temp[i]);
            }
            this.setValue(tClass, obj, key, stringBuffer.toString());
        }
    }

    private void setValue(Class tClass, Object obj, String name, String value) {
        Field[] fields = tClass.getDeclaredFields();
        Class<?> type = null;
        for (Field field : fields) {
            if (!field.getName().equals(name)) continue;
            type = field.getType();
            break;
        }
        if (type == null) {
            Class superClass = tClass.getSuperclass();
            if (superClass != Object.class) {
                this.setValue(superClass, obj, name, value);
            }
            return;
        }
        try {
            Method method = AbstractBaseControl.getMethod(tClass, name, type);
            if (type == Integer.TYPE || type == Integer.class) {
                try {
                    Integer integer = Integer.valueOf(value);
                    method.invoke(obj, integer);
                }
                catch (NumberFormatException integer) {}
            } else if (type == String.class) {
                method.invoke(obj, value);
            } else if (AbstractBaseControl.class.isAssignableFrom(type)) {
                Object type_obj = type.newInstance();
                Method setIdMethod = AbstractBaseControl.getMethod(type_obj.getClass(), "Id", Integer.class);
                try {
                    setIdMethod.invoke(type_obj, Integer.valueOf(value));
                    method.invoke(obj, type_obj);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (type == Double.class || type == Double.TYPE) {
                try {
                    Double double_v = Double.valueOf(value);
                    method.invoke(obj, double_v);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                DefaultSystemLog.ERROR().error("\u6ca1\u6709\u8bbe\u7f6e:" + type, (Throwable)new RuntimeException());
            }
            System.out.println(type + "  " + name + "  " + value);
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error("\u521b\u5efa\u5bf9\u8c61\u9519\u8bef", (Throwable)e);
        }
    }

    private static Method getMethod(Class<?> tClass, String name, Class type) throws NoSuchMethodException {
        try {
            return tClass.getDeclaredMethod(AbstractBaseControl.parSetName(name), type);
        }
        catch (NoSuchMethodException e) {
            Class<?> superClass = tClass.getSuperclass();
            if (superClass != Object.class) {
                return AbstractBaseControl.getMethod(superClass, name, type);
            }
            throw e;
        }
    }

    private static String parSetName(String fieldName) {
        if (null == fieldName || "".equals(fieldName)) {
            return null;
        }
        int startIndex = 0;
        if (fieldName.charAt(0) == '_') {
            startIndex = 1;
        }
        return "set" + fieldName.substring(startIndex, startIndex + 1).toUpperCase() + fieldName.substring(startIndex + 1);
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ipFromNginx = request.getHeader(default_headerName);
        if (ipFromNginx != null && ipFromNginx.length() > 0) {
            return ipFromNginx;
        }
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        ip = StringUtil.convertNULL(ip);
        return ip;
    }
}

