/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.controller.base;

import cn.jiangzeyin.common.request.ParameterXssWrapper;
import cn.jiangzeyin.controller.base.AbstractBaseControl;
import cn.jiangzeyin.controller.multipart.MultipartFileConfig;
import cn.jiangzeyin.util.FileUtil;
import cn.jiangzeyin.util.ReflectUtil;
import cn.jiangzeyin.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public abstract class AbstractMultipartFileBaseControl
extends AbstractBaseControl {
    private static final ThreadLocal<Map<String, String[]>> MAP_THREAD_LOCAL_PARAMETER = new ThreadLocal();
    private static final ThreadLocal<MultipartHttpServletRequest> THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST = new ThreadLocal();

    protected Map<String, String[]> getParameter() {
        return MAP_THREAD_LOCAL_PARAMETER.get();
    }

    protected MultipartHttpServletRequest getMultiRequest() {
        MultipartHttpServletRequest multipartHttpServletRequest = THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST.get();
        Assert.notNull((Object)multipartHttpServletRequest);
        return multipartHttpServletRequest;
    }

    @Override
    public void setReqAndRes(HttpServletRequest request, HttpSession session, HttpServletResponse response) {
        super.setReqAndRes(request, session, response);
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST.set((MultipartHttpServletRequest)request);
            MAP_THREAD_LOCAL_PARAMETER.set(ParameterXssWrapper.doXss(this.getMultiRequest().getParameterMap(), false));
        }
    }

    @Override
    public HttpServletRequest getRequest() {
        if (this.getMultiRequest() == null) {
            return super.getRequest();
        }
        return this.getMultiRequest();
    }

    protected MultipartFile getFile(String name) {
        return this.getMultiRequest().getFile(name);
    }

    protected List<MultipartFile> getFiles(String name) {
        return this.getMultiRequest().getFiles(name);
    }

    @Override
    public <T> T getObject(Class<T> tClass) throws IllegalAccessException, InstantiationException {
        Map<String, String[]> parameter = this.getParameter();
        if (parameter == null) {
            return super.getObject(tClass);
        }
        T object = tClass.newInstance();
        this.doParameterMap(parameter, object);
        return object;
    }

    protected <T> T getUpload(Class<T> cls, String path, String ... name) throws IllegalAccessException, InstantiationException, IOException {
        Map<String, String[]> parameter = this.getParameter();
        Assert.notNull(parameter);
        if (name == null || name.length <= 0) {
            return null;
        }
        path = StringUtil.convertNULL(path);
        T object = cls.newInstance();
        String localPath = MultipartFileConfig.getFileTempPath();
        for (String aName : name) {
            String fileName;
            MultipartFile multiFile = this.getFile(aName);
            if (multiFile == null || (fileName = multiFile.getOriginalFilename()) == null || fileName.length() <= 0) continue;
            String filePath = FileUtil.clearPath(String.format("%s/%s/%s_%s", localPath, path, System.currentTimeMillis(), fileName));
            boolean flag = FileUtil.writeInputStream(multiFile.getInputStream(), new File(filePath));
            if (!flag) {
                throw new RuntimeException(filePath + " write fail");
            }
            ReflectUtil.setFieldValue(object, aName, filePath);
        }
        this.doParameterMap(parameter, object);
        return object;
    }

    @Override
    public String[] getParameters(String name) {
        Map<String, String[]> parameter = this.getParameter();
        if (parameter == null) {
            return super.getParameters(name);
        }
        return parameter.get(name);
    }

    @Override
    protected String getParameter(String name) {
        String[] values = this.getParameters(name);
        return values == null ? null : values[0];
    }

    @Override
    protected String getParameter(String name, String def) {
        String value = this.getParameter(name);
        return value == null ? def : value;
    }

    @Override
    protected int getParameterInt(String name) {
        return this.getParameterInt(name, 0);
    }

    @Override
    protected int getParameterInt(String name, int def) {
        String value = this.getParameter(name);
        return StringUtil.parseInt(value, def);
    }
}

