/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.controller.base;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public final class RequestUtil {
    public static Cookie getCookieByName(HttpServletRequest request, String name) {
        Map<String, Cookie> cookieMap = RequestUtil.readCookieMap(request);
        return cookieMap.getOrDefault(name, null);
    }

    private static Map<String, Cookie> readCookieMap(HttpServletRequest request) {
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie);
            }
        }
        return cookieMap;
    }

    public static Map<String, String> getHeaderMapValues(HttpServletRequest request) {
        Enumeration enumeration = request.getHeaderNames();
        HashMap<String, String> headerMapValues = new HashMap<String, String>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                headerMapValues.put(name, request.getHeader(name));
            }
        }
        return headerMapValues;
    }
}

