/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.util;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.util.Assert;

public final class FileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeInputStream(InputStream inputStream, File file) throws IOException {
        Assert.notNull((Object)inputStream);
        Assert.notNull((Object)file);
        File parent = file.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IllegalArgumentException(file.getPath() + " create fail");
        }
        DataOutputStream outputStream = null;
        try {
            outputStream = new DataOutputStream(new FileOutputStream(file));
            int len = inputStream.available();
            if (len <= 0x100000) {
                byte[] bytes = new byte[len];
                int rLen = inputStream.read(bytes);
                if (rLen > 0) {
                    outputStream.write(bytes);
                }
            } else {
                int byteCount;
                byte[] bytes = new byte[0x100000];
                while ((byteCount = inputStream.read(bytes)) != -1) {
                    outputStream.write(bytes, 0, byteCount);
                }
            }
        }
        finally {
            inputStream.close();
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return true;
    }

    public static String clearPath(String input) {
        input = input.replace('\\', '/');
        return FileUtil.clearPath_(input);
    }

    private static String clearPath_(String input) {
        int i;
        int from = 0;
        int j = input.indexOf("://");
        if (j != -1) {
            from = j + 3;
        }
        if ((i = input.indexOf("//", from)) == -1) {
            return input;
        }
        String input_ = input.substring(0, i) + "/" + input.substring(i + 2);
        return FileUtil.clearPath_(input_);
    }
}

