/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;

public final class ReflectCache {
    private static final ConcurrentHashMap<String, Field> fieldMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Field[]> fieldsMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Method> methodMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Method[]> methodsMap = new ConcurrentHashMap();

    public static Field[] getDeclaredFields(Class<?> cls) {
        Field[] fields = fieldsMap.get(cls.getName());
        if (fields == null) {
            fields = cls.getDeclaredFields();
            fieldsMap.put(cls.getName(), fields);
        }
        return fields;
    }

    public static Field getDeclaredField(Class<?> cls, String name) throws NoSuchFieldException, SecurityException {
        Field field = fieldMap.get(cls.getName() + "." + name);
        if (field == null) {
            field = cls.getDeclaredField(name);
            field.setAccessible(true);
            fieldMap.put(cls.getName() + "." + name, field);
        }
        return field;
    }

    public static Method getDeclaredMethod(Class<?> cls, String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        String mapname = cls.getName() + "." + name + "." + ReflectCache.ParameterTypestoString(parameterTypes);
        Method method = methodMap.get(name);
        if (method == null) {
            method = cls.getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
            methodMap.put(mapname, method);
        }
        return method;
    }

    public static Method[] getDeclaredMethods(Class<?> cls) throws NoSuchMethodException, SecurityException {
        Method[] method = methodsMap.get(cls.getName());
        if (method == null) {
            method = cls.getDeclaredMethods();
            methodsMap.put(cls.getName(), method);
        }
        return method;
    }

    private static String ParameterTypestoString(Class<?> ... parameterTypes) {
        if (parameterTypes == null) {
            return "";
        }
        String name = "";
        for (Class<?> class1 : parameterTypes) {
            name = class1.getName() + ",";
        }
        return name;
    }
}

