/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.util;

import cn.jiangzeyin.util.ReflectCache;
import cn.jiangzeyin.util.StringUtil;
import java.lang.reflect.Field;

public final class ReflectUtil {
    public static Field getField(Class<?> cls, String fieldName) {
        Field field = null;
        for (Class<?> clazz = cls; clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = ReflectCache.getDeclaredField(clazz, fieldName);
                break;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return field;
    }

    public static void setFieldValue(Object obj, String fieldName, Object fieldValue) throws IllegalAccessException {
        Field field = ReflectUtil.getField(obj.getClass(), fieldName);
        if (field != null) {
            field.setAccessible(true);
            Class<?> type = field.getType();
            String typeName = type.getSimpleName();
            if (typeName.equalsIgnoreCase("int")) {
                field.set(obj, StringUtil.parseInt(fieldValue.toString()));
            } else if (typeName.equalsIgnoreCase("double")) {
                field.set(obj, StringUtil.parseDouble(fieldValue.toString()));
            } else if (typeName.equalsIgnoreCase("string")) {
                if (fieldValue == null) {
                    field.set(obj, "");
                } else {
                    field.set(obj, fieldValue.toString());
                }
            } else if (typeName.equalsIgnoreCase("long")) {
                field.set(obj, StringUtil.parseLong(fieldValue.toString()));
            } else if (type == Integer.class) {
                field.set(obj, Integer.valueOf(fieldValue.toString()));
            } else {
                field.set(obj, fieldValue);
            }
        }
    }
}

